/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.image.BufferedImage;
import javax.swing.Icon;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.ShowOriginalHelper;
import pixelitor.filters.gui.BooleanParam;

public abstract class FilterWithSOParametrizedGUI
extends FilterWithParametrizedGUI {
    protected BooleanParam showOriginalParam = BooleanParam.createParamForShowOriginal();
    private ShowOriginalHelper showOriginalHelper = new ShowOriginalHelper();

    protected FilterWithSOParametrizedGUI(String string) {
        super(string);
    }

    protected FilterWithSOParametrizedGUI(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void endDialogSession() {
        BufferedImage bufferedImage = this.showOriginalHelper.getLastTransformed();
        if (bufferedImage != null) {
            this.showOriginalHelper.setLastTransformed(null);
        }
        this.showOriginalHelper.setPreviousShowOriginal(false);
    }

    @Override
    protected BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        boolean bl = this.showOriginalParam.getValue();
        this.showOriginalHelper.setShowOriginal(bl);
        if (bl) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        if (this.showOriginalHelper.showCached()) {
            bufferedImage2 = this.showOriginalHelper.getLastTransformed();
            assert (bufferedImage2 != null);
            return bufferedImage2;
        }
        bufferedImage2 = this.realTransform(bufferedImage, bufferedImage2);
        this.showOriginalHelper.setLastTransformed(bufferedImage2);
        return bufferedImage2;
    }

    public abstract BufferedImage realTransform(BufferedImage var1, BufferedImage var2);
}

