/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.image.BufferedImage;
import pixelitor.filters.Filter;
import pixelitor.utils.ImageUtils;

public class Invert
extends Filter {
    public Invert() {
        super("Invert");
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Invert.invertImage(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public static void invertImage(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        int[] nArray2 = ImageUtils.getPixelsAsArray(bufferedImage2);
        boolean bl = !bufferedImage.isAlphaPremultiplied();
        for (int i = 0; i < nArray2.length; ++i) {
            int n = nArray[i];
            int n2 = n >>> 24 & 0xFF;
            if (n2 == 255 || bl) {
                nArray2[i] = n ^ 0xFFFFFF;
                continue;
            }
            if (n2 == 0) {
                nArray2[i] = 0;
                continue;
            }
            int n3 = n >>> 16 & 0xFF;
            int n4 = n >>> 8 & 0xFF;
            int n5 = n & 0xFF;
            float f = 255.0f / (float)n2;
            int n6 = (int)((float)n3 * f);
            int n7 = (int)((float)n4 * f);
            int n8 = (int)((float)n5 * f);
            if (n6 > 255) {
                n6 = 255;
            }
            if (n7 > 255) {
                n7 = 255;
            }
            if (n8 > 255) {
                n8 = 255;
            }
            n6 = 255 - n6;
            n7 = 255 - n7;
            n8 = 255 - n8;
            float f2 = (float)n2 * 0.003921569f;
            n3 = (int)((float)n6 * f2);
            n4 = (int)((float)n7 * f2);
            n5 = (int)((float)n8 * f2);
            n3 = ImageUtils.limitTo8Bits(n3);
            n4 = ImageUtils.limitTo8Bits(n4);
            n5 = ImageUtils.limitTo8Bits(n5);
            nArray2[i] = n2 << 24 | n3 << 16 | n4 << 8 | n5;
        }
    }

    @Override
    public void randomizeSettings() {
    }
}

