/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import pixelitor.Build;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ActionParam;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.BlendingModeParam;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.ElevationAngleParam;
import pixelitor.filters.gui.GradientParam;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.gui.RangeWithColorsParam;
import pixelitor.filters.gui.TextParam;
import pixelitor.layers.BlendingMode;
import pixelitor.utils.ImageUtils;

public class ParamTest
extends FilterWithParametrizedGUI {
    private float[] defaultThumbPositions = new float[]{0.0f, 0.5f, 1.0f};
    private Color[] defaultValues = new Color[]{Color.BLACK, Color.BLUE, Color.WHITE};
    private GradientParam gradientParam = new GradientParam("Colors", this.defaultThumbPositions, this.defaultValues);
    private RangeParam rangeParam = new RangeParam("RangeParam", 0, 100, 50);
    private RangeWithColorsParam rangeWithColorsParam = new RangeWithColorsParam(Color.RED, Color.BLUE, "RangeWithColorsParam", 0, 100, 50);
    private ImagePositionParam centerParam = new ImagePositionParam("ImagePositionParam");
    private IntChoiceParam edgeActionParam = new IntChoiceParam("IntChoiceParam", new IntChoiceParam.Value[]{new IntChoiceParam.Value("value 1", 1), new IntChoiceParam.Value("value 2", 2)});
    private ColorParam colorParam = new ColorParam("ColorParam:", Color.WHITE, true, true);
    private ActionParam actionParam = new ActionParam("ActionParam", new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    });
    private AngleParam angleParam = new AngleParam("AngleParam", 0.0);
    private ElevationAngleParam elevationAngleParam = new ElevationAngleParam("ElevationAngleParam", 0.0);
    private BlendingModeParam blendingModeParam = new BlendingModeParam(BlendingMode.values());
    private BooleanParam booleanParam = new BooleanParam("BooleanParam", false);
    private TextParam textParam = new TextParam("TextParam", "default value");

    public ParamTest() {
        super("ParamTest");
        this.paramSet = new ParamSet(this.gradientParam, this.rangeParam, this.rangeWithColorsParam, this.centerParam, this.edgeActionParam, this.colorParam, this.actionParam, this.angleParam, this.elevationAngleParam, this.blendingModeParam, this.booleanParam, this.textParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (Build.CURRENT == Build.DEVELOPMENT && !Build.CURRENT.isRobotTest()) {
            System.out.println("ParamTest.transform CALLED");
        }
        bufferedImage2 = ImageUtils.copyImage(bufferedImage);
        return bufferedImage2;
    }
}

