/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.image.BufferedImage;
import java.awt.image.ShortLookupTable;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.GUIParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.levels.RGBLookup;
import pixelitor.filters.lookup.FastLookupOp;

public class Posterize
extends FilterWithParametrizedGUI {
    private RangeParam levels = new RangeParam("Levels", 2, 255, 2);

    public Posterize() {
        super("Posterize");
        this.paramSet = new ParamSet((GUIParam)this.levels);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = this.levels.getValue();
        RGBLookup rGBLookup = new RGBLookup();
        rGBLookup.initFromPosterize(n);
        FastLookupOp fastLookupOp = new FastLookupOp((ShortLookupTable)rGBLookup.getLookupOp());
        fastLookupOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

