/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Random;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ActionParam;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;

public class ValueNoise
extends FilterWithParametrizedGUI {
    private static Random rand = new Random();
    private static int r1;
    private static int r2;
    private static int r3;
    private RangeParam scale = new RangeParam("Zoom (%)", 1, 300, 100);
    private RangeParam details = new RangeParam("Octaves (Details)", 1, 8, 5);
    private ActionParam reseedAction = new ActionParam("Reseed", new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ValueNoise.reseed();
        }
    });
    private ColorParam color1Param = new ColorParam("Color 1", Color.BLACK, true, false);
    private ColorParam color2Param = new ColorParam("Color 2", Color.WHITE, true, false);

    public ValueNoise() {
        super("Value Noise");
        this.paramSet = new ParamSet(this.scale, this.details, this.color1Param, this.color2Param, this.reseedAction);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int[] nArray = new int[256];
        Color color = this.color1Param.getColor();
        Color color2 = this.color2Param.getColor();
        int[] nArray2 = new int[]{color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue()};
        int[] nArray3 = new int[]{color2.getAlpha(), color2.getRed(), color2.getGreen(), color2.getBlue()};
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = ImageUtils.lerpAndPremultiplyColorWithAlpha((float)i / 255.0f, nArray2, nArray3);
        }
        int[] nArray4 = ImageUtils.getPixelsAsArray(bufferedImage2);
        n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        float f = 1.0f / (float)this.scale.getValue();
        float f2 = 0.6f;
        float f3 = 1.0f;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3;
                int n4 = this.details.getValue();
                int n5 = (int)(255.0f * ValueNoise.generateValueNoise(i, j, n4, f, f2, f3));
                nArray4[i + j * n] = n3 = nArray[n5];
            }
        }
        return bufferedImage2;
    }

    public static float generateValueNoise(int n, int n2, int n3, float f, float f2, float f3) {
        float f4 = 0.0f;
        for (int i = 0; i < n3; ++i) {
            f4 += ValueNoise.smooth((float)n * f, (float)n2 * f) * f3;
            f *= 2.0f;
            f3 *= f2;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        return f4;
    }

    private static float smooth(float f, float f2) {
        float f3 = ValueNoise.noise((int)f, (int)f2);
        float f4 = ValueNoise.noise((int)f + 1, (int)f2);
        float f5 = ValueNoise.noise((int)f, (int)f2 + 1);
        float f6 = ValueNoise.noise((int)f + 1, (int)f2 + 1);
        float f7 = ValueNoise.interpolate(f3, f4, f - (float)((int)f));
        float f8 = ValueNoise.interpolate(f5, f6, f - (float)((int)f));
        return ValueNoise.interpolate(f7, f8, f2 - (float)((int)f2));
    }

    public static void reseed() {
        r1 = 1000 + rand.nextInt(90000);
        r2 = 10000 + rand.nextInt(900000);
        r3 = 100000 + rand.nextInt(1000000000);
    }

    private static float noise(int n, int n2) {
        int n3 = n + n2 * 57;
        n3 = n3 << 13 ^ n3;
        return 1.0f - (float)(n3 * (n3 * n3 * r1 + r2) + r3 & Integer.MAX_VALUE) / 1.0737418E9f;
    }

    private static float interpolate(float f, float f2, float f3) {
        float f4 = (float)((1.0 - Math.cos((double)f3 * Math.PI)) * 0.5);
        return f * (1.0f - f4) + f2 * f4;
    }

    public void setDetails(int n) {
        this.details.setValue(n);
    }

    static {
        ValueNoise.reseed();
    }
}

