/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.comp;

import java.awt.Dimension;
import java.awt.Rectangle;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.ImageComponent;
import pixelitor.history.OneLayerUndoableEdit;
import pixelitor.layers.Layer;
import pixelitor.selection.Selection;

public final class CompositionUtils {
    private CompositionUtils() {
    }

    public static void cropImage(Composition composition, Selection selection) {
        Rectangle rectangle = selection.getShapeBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        OneLayerUndoableEdit.createAndAddToHistory(composition, "Crop", false, true);
        composition.deselect(false);
        int n = composition.getNrLayers();
        for (int i = 0; i < n; ++i) {
            Layer layer = composition.getLayer(i);
            layer.crop(rectangle);
        }
        composition.updateCanvasSize(rectangle.width, rectangle.height);
        composition.setDirty(true);
        composition.imageChanged(true, true);
        ImageComponent imageComponent = composition.getIC();
        imageComponent.setPreferredSize(new Dimension(rectangle.width, rectangle.height));
        imageComponent.revalidate();
        imageComponent.makeSureItIsVisible();
        AppLogic.activeCompositionDimensionsChanged(composition);
    }

    public static void resize(Composition composition, int n, int n2, boolean bl) {
        boolean bl2;
        int n3;
        int n4 = composition.getCanvasWidth();
        int n5 = composition.getCanvasHeight();
        if (n4 == n && n5 == n2) {
            return;
        }
        if (bl) {
            int bl22 = n;
            n3 = n2;
            double d = (double)n3 / (double)n5;
            double d2 = (double)bl22 / (double)n4;
            double d3 = Math.min(d, d2);
            n = (int)(d3 * (double)n4);
            n2 = (int)(d3 * (double)n5);
        }
        boolean bl3 = false;
        if (n < n4 / 2 || n2 < n5 / 2) {
            bl2 = true;
        }
        OneLayerUndoableEdit.createAndAddToHistory(composition, "Resize", false, true);
        composition.deselect(false);
        n3 = composition.getNrLayers();
        for (int i = 0; i < n3; ++i) {
            Layer layer = composition.getLayer(i);
            layer.resize(n, n2, bl2);
        }
        composition.updateCanvasSize(n, n2);
        composition.imageChanged(false, false);
        AppLogic.activeCompositionDimensionsChanged(composition);
    }
}

