/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.convolve;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImagingOpException;
import java.awt.image.Kernel;
import java.util.Random;
import org.jdesktop.swingx.combobox.EnumComboBoxModel;
import pixelitor.ExceptionHandler;
import pixelitor.filters.convolve.ConvolveMethod;
import pixelitor.filters.convolve.CustomConvolveAdjustments;
import pixelitor.filters.gui.AdjustPanel;
import pixelitor.filters.gui.FilterWithGUI;

public class Convolve
extends FilterWithGUI {
    private EnumComboBoxModel<ConvolveMethod> convolveMethodModel = new EnumComboBoxModel<ConvolveMethod>(ConvolveMethod.class);
    private float[] kernelMatrix;
    private int size;

    public Convolve(int n) {
        super("Custom " + n + 'x' + n + " Convolution");
        this.size = n;
    }

    public void setKernelMatrix(float[] fArray) {
        if (fArray.length != this.size * this.size) {
            throw new IllegalArgumentException("kernelMatrix.length = " + fArray.length + ", size = " + this.size);
        }
        this.kernelMatrix = fArray;
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Kernel kernel = new Kernel(this.size, this.size, this.kernelMatrix);
        BufferedImageOp bufferedImageOp = ((ConvolveMethod)((Object)this.convolveMethodModel.getSelectedItem())).getConvolveOp(kernel);
        try {
            bufferedImageOp.filter(bufferedImage, bufferedImage2);
        }
        catch (ImagingOpException imagingOpException) {
            ExceptionHandler.showExceptionDialog(imagingOpException);
        }
        return bufferedImage2;
    }

    @Override
    public AdjustPanel getAdjustPanel() {
        return new CustomConvolveAdjustments(this);
    }

    public EnumComboBoxModel<ConvolveMethod> getConvolveMethodModel() {
        return this.convolveMethodModel;
    }

    @Override
    public void randomizeSettings() {
        this.kernelMatrix = Convolve.getRandomKernelMatrix(this.size);
    }

    public static float[] getRandomKernelMatrix(int n) {
        Random random = new Random();
        float[] fArray = new float[n * n];
        for (int i = 0; i < fArray.length; ++i) {
            int n2 = random.nextInt(10000);
            fArray[i] = (float)(4 * n2) / (10000.0f * (float)fArray.length) - 1.0f / (float)fArray.length;
        }
        return fArray;
    }

    public int getSize() {
        return this.size;
    }
}

