/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import pixelitor.filters.gui.AngleParam;

public abstract class AbstractAngleSelectorComponent
extends JComponent
implements MouseListener,
MouseMotionListener {
    AngleParam model;
    static final int SIZE = 50;
    int cx;
    int cy;

    AbstractAngleSelectorComponent(AngleParam angleParam) {
        this.model = angleParam;
        Dimension dimension = new Dimension(51, 51);
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void updateAngle(int n, int n2, boolean bl) {
        double d = Math.atan2(n2 - this.cy, n - this.cx);
        this.repaint();
        this.model.setValueInRadians(d, bl);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.updateAngle(mouseEvent.getX(), mouseEvent.getY(), false);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateAngle(mouseEvent.getX(), mouseEvent.getY(), true);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateAngle(mouseEvent.getX(), mouseEvent.getY(), false);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    static void drawArrow(Graphics2D graphics2D, double d, float f, float f2, float f3, float f4) {
        Line2D.Float float_ = new Line2D.Float(f, f2, f3, f4);
        graphics2D.draw(float_);
        double d2 = 2.8797926 + d;
        double d3 = 3.4033926 + d;
        int n = 10;
        float f5 = (float)((double)f3 + (double)n * Math.cos(d2));
        float f6 = (float)((double)f4 + (double)n * Math.sin(d2));
        float f7 = (float)((double)f3 + (double)n * Math.cos(d3));
        float f8 = (float)((double)f4 + (double)n * Math.sin(d3));
        Line2D.Float float_2 = new Line2D.Float(f3, f4, f5, f6);
        Line2D.Float float_3 = new Line2D.Float(f3, f4, f7, f8);
        graphics2D.draw(float_2);
        graphics2D.draw(float_3);
    }
}

