/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pixelitor.filters.gui.AbstractGUIParam;
import pixelitor.filters.gui.CoupledRangeSelector;
import pixelitor.filters.gui.ParamAdjustmentListener;
import pixelitor.filters.gui.RangeParam;

public class CoupledRangeParam
extends AbstractGUIParam {
    private RangeParam rangeParam1;
    private RangeParam rangeParam2;
    private JToggleButton.ToggleButtonModel checkBoxModel;
    private boolean coupledByDefault;

    public CoupledRangeParam(String string, int n, int n2, int n3) {
        this(string, "Horizontal:", "Vertical:", n, n2, n3, true);
    }

    public CoupledRangeParam(String string, String string2, String string3, int n, int n2, int n3, boolean bl) {
        super(string);
        this.rangeParam1 = new RangeParam(string2, n, n2, n3);
        this.rangeParam2 = new RangeParam(string3, n, n2, n3);
        this.checkBoxModel = new JToggleButton.ToggleButtonModel();
        this.coupledByDefault = bl;
        this.setCoupled(this.coupledByDefault);
        this.rangeParam1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (CoupledRangeParam.this.isCoupled()) {
                    CoupledRangeParam.this.rangeParam2.setDontTrigger(true);
                    CoupledRangeParam.this.rangeParam2.setValue(CoupledRangeParam.this.rangeParam1.getValue());
                    CoupledRangeParam.this.rangeParam2.setDontTrigger(false);
                }
            }
        });
        this.rangeParam2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (CoupledRangeParam.this.isCoupled()) {
                    CoupledRangeParam.this.rangeParam1.setDontTrigger(true);
                    CoupledRangeParam.this.rangeParam1.setValue(CoupledRangeParam.this.rangeParam2.getValue());
                    CoupledRangeParam.this.rangeParam1.setDontTrigger(false);
                }
            }
        });
    }

    public JToggleButton.ToggleButtonModel getCheckBoxModel() {
        return this.checkBoxModel;
    }

    @Override
    public void setAdjustmentListener(ParamAdjustmentListener paramAdjustmentListener) {
        this.rangeParam1.setAdjustmentListener(paramAdjustmentListener);
        this.rangeParam2.setAdjustmentListener(paramAdjustmentListener);
    }

    @Override
    public JComponent createGUI() {
        return new CoupledRangeSelector(this);
    }

    public int getFirstValue() {
        return this.rangeParam1.getValue();
    }

    public int getSecondValue() {
        return this.rangeParam2.getValue();
    }

    public void setFirstValue(int n) {
        this.rangeParam1.setValue(n);
    }

    public void setSecondValue(int n) {
        this.rangeParam2.setValue(n);
    }

    public boolean isCoupled() {
        return this.checkBoxModel.isSelected();
    }

    public void setCoupled(boolean bl) {
        this.checkBoxModel.setSelected(bl);
    }

    @Override
    public int getNrOfGridBagCols() {
        return 1;
    }

    @Override
    public void randomize() {
        if (this.isCoupled()) {
            this.rangeParam1.randomize();
        } else {
            this.rangeParam1.randomize();
            this.rangeParam2.randomize();
        }
    }

    @Override
    public void setDontTrigger(boolean bl) {
        this.rangeParam1.setDontTrigger(bl);
        this.rangeParam2.setDontTrigger(bl);
    }

    @Override
    public boolean isSetToDefault() {
        return this.rangeParam1.isSetToDefault() && this.rangeParam2.isSetToDefault();
    }

    @Override
    public void reset(boolean bl) {
        this.rangeParam1.reset(false);
        this.rangeParam2.reset(bl);
        this.setCoupled(this.coupledByDefault);
    }

    public RangeParam getFirstRangeParam() {
        return this.rangeParam1;
    }

    public RangeParam getSecondRangeParam() {
        return this.rangeParam2;
    }
}

