/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import javax.swing.JComponent;
import pixelitor.filters.gui.AbstractGUIParam;
import pixelitor.filters.gui.ImagePositionPanel;
import pixelitor.filters.gui.ParamAdjustmentListener;
import pixelitor.filters.gui.ParamGUI;

public class ImagePositionParam
extends AbstractGUIParam {
    private float relativeX = 0.5f;
    private float relativeY = 0.5f;
    private ParamGUI paramGUI;

    public ImagePositionParam(String string) {
        super(string);
    }

    @Override
    public boolean isSetToDefault() {
        return false;
    }

    @Override
    public JComponent createGUI() {
        ImagePositionPanel imagePositionPanel = new ImagePositionPanel(this);
        this.paramGUI = imagePositionPanel;
        this.paramGUI.updateGUI();
        return imagePositionPanel;
    }

    @Override
    public void reset(boolean bl) {
        if (!bl) {
            this.dontTrigger = true;
        }
        this.setRelativeValues(0.5f, 0.5f, true);
        this.dontTrigger = false;
    }

    @Override
    public int getNrOfGridBagCols() {
        return 1;
    }

    @Override
    public void randomize() {
        this.setRelativeValues((float)Math.random(), (float)Math.random(), true);
    }

    public ParamAdjustmentListener getAdjustingListener() {
        return this.adjustmentListener;
    }

    public float getRelativeX() {
        return this.relativeX;
    }

    public float getRelativeY() {
        return this.relativeY;
    }

    private void setRelativeValues(float f, float f2, boolean bl) {
        this.relativeX = f;
        this.relativeY = f2;
        if (bl && this.paramGUI != null) {
            this.paramGUI.updateGUI();
        }
        if (!this.dontTrigger) {
            // empty if block
        }
    }

    public void setRelativeX(float f) {
        this.setRelativeValues(f, this.relativeY, false);
    }

    public void setRelativeY(float f) {
        this.setRelativeValues(this.relativeX, f, false);
    }
}

