/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.impl;

import com.jhlabs.image.TransformFilter;
import java.awt.image.BufferedImage;

public class MirrorFilter
extends TransformFilter {
    private float centerX;
    private float centerY;
    private int cx;
    private int cy;
    public static final int LEFT_OVER_RIGHT = 0;
    public static final int RIGHT_OVER_LEFT = 1;
    public static final int BOTTOM_OVER_TOP = 2;
    public static final int TOP_OVER_BOTTOM = 3;
    private int type;

    public void setType(int n) {
        this.type = n;
    }

    public void setCenterX(float f) {
        this.centerX = f;
    }

    public void setCenterY(float f) {
        this.centerY = f;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.cx = (int)(this.centerX * (float)bufferedImage.getWidth());
        this.cy = (int)(this.centerY * (float)bufferedImage.getHeight());
        return super.filter(bufferedImage, bufferedImage2);
    }

    @Override
    protected void transformInverse(int n, int n2, float[] fArray) {
        switch (this.type) {
            case 0: {
                if (n < this.cx) {
                    fArray[0] = n;
                    fArray[1] = n2;
                    break;
                }
                fArray[0] = this.cx + this.cx - n;
                fArray[1] = n2;
                break;
            }
            case 1: {
                if (n > this.cx) {
                    fArray[0] = n;
                    fArray[1] = n2;
                    break;
                }
                fArray[0] = this.cx + this.cx - n;
                fArray[1] = n2;
                break;
            }
            case 3: {
                if (n2 < this.cy) {
                    fArray[0] = n;
                    fArray[1] = n2;
                    break;
                }
                fArray[0] = n;
                fArray[1] = this.cy + this.cy - n2;
                break;
            }
            case 2: {
                if (n2 > this.cy) {
                    fArray[0] = n;
                    fArray[1] = n2;
                    break;
                }
                fArray[0] = n;
                fArray[1] = this.cy + this.cy - n2;
            }
        }
    }
}

