/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.impl;

import com.jhlabs.image.TransformFilter;
import java.awt.image.BufferedImage;

public class TileFilter
extends TransformFilter {
    private float scaleX;
    private float scaleY;
    private float halfWidth;
    private float halfHeight;
    private float curvature;

    public void setSizeX(int n) {
        this.scaleX = (float)(Math.PI / (double)n);
    }

    public void setSizeY(int n) {
        this.scaleY = (float)(Math.PI / (double)n);
    }

    public void setCurvature(float f) {
        this.curvature = f * f / 10.0f;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.halfWidth = (float)bufferedImage.getWidth() / 2.0f;
        this.halfHeight = (float)bufferedImage.getHeight() / 2.0f;
        return super.filter(bufferedImage, bufferedImage2);
    }

    @Override
    protected void transformInverse(int n, int n2, float[] fArray) {
        float f = (float)n - this.halfWidth;
        float f2 = (float)n2 - this.halfHeight;
        float f3 = (float)((double)f + (double)this.curvature * Math.tan(f * this.scaleX));
        float f4 = (float)((double)f2 + (double)this.curvature * Math.tan(f2 * this.scaleY));
        fArray[0] = this.halfWidth + f3;
        fArray[1] = this.halfHeight + f4;
    }
}

