/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.BoxBlurFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithSOParametrizedGUI;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.CoupledRangeParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;

public class JHBoxBlur
extends FilterWithSOParametrizedGUI {
    private CoupledRangeParam radius = new CoupledRangeParam("Radius", 0, 100, 0);
    private RangeParam numberOfIterations = new RangeParam("Number of Iterations", 1, 10, 3);
    private BooleanParam hpSharpening = BooleanParam.createParamForHPSharpening();
    private BoxBlurFilter filter;

    public JHBoxBlur() {
        super("Box Blur");
        this.paramSet = new ParamSet(this.radius, this.numberOfIterations, this.hpSharpening, this.showOriginalParam);
    }

    @Override
    public BufferedImage realTransform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = this.radius.getFirstValue();
        int n2 = this.radius.getSecondValue();
        if (n == 0 && n2 == 0) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        if (this.filter == null) {
            this.filter = new BoxBlurFilter();
        }
        this.filter.setHRadius(n);
        this.filter.setVRadius(n2);
        this.filter.setIterations(this.numberOfIterations.getValue());
        this.filter.setPremultiplyAlpha(false);
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        if (this.hpSharpening.getValue()) {
            bufferedImage2 = ImageUtils.getHighPassSharpenedImage(bufferedImage, bufferedImage2);
        }
        return bufferedImage2;
    }
}

