/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.CausticsFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.gui.ReseedNoiseAction;

public class JHCaustics
extends FilterWithParametrizedGUI {
    private RangeParam scale = new RangeParam("Zoom (%)", 1, 500, 100);
    private RangeParam brightness = new RangeParam("Brightness", 0, 20, 7);
    private RangeParam focus = new RangeParam("Focus", 0, 100, 50);
    private RangeParam dispersion = new RangeParam("Dispersion (Color Separation)", 0, 100, 0);
    private RangeParam samples = new RangeParam("Samples (Quality)", 1, 10, 1);
    private RangeParam turbulence = new RangeParam("Turbulence", 0, 8, 0);
    private RangeParam time = new RangeParam("Time", 0, 999, 0);
    private ColorParam bgColor = new ColorParam("Background Color", new Color(0, 200, 175), false, false);
    private CausticsFilter filter;

    public JHCaustics() {
        super("Caustics");
        this.paramSet = new ParamSet(this.bgColor, this.scale, this.brightness, this.samples, this.turbulence, this.time, this.focus, this.dispersion, new ReseedNoiseAction());
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new CausticsFilter();
        }
        this.filter.setAmount(this.focus.getValueAsPercentage());
        this.filter.setBgColor(this.bgColor.getColor().getRGB());
        this.filter.setBrightness(this.brightness.getValue());
        this.filter.setDispersion(this.dispersion.getValueAsPercentage());
        this.filter.setSamples(this.samples.getValue());
        this.filter.setScale(this.scale.getValue());
        this.filter.setTime(this.time.getValueAsPercentage());
        this.filter.setTurbulence(this.turbulence.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

