/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.CellularFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.GradientParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHCells
extends FilterWithParametrizedGUI {
    private static final int TYPE_CELLS = 1;
    private static final int TYPE_GRID = 2;
    private static final int TYPE_STRANGE = 3;
    private GradientParam gradientParam = new GradientParam("Colors", Color.BLACK, Color.WHITE);
    private RangeParam scaleParam = new RangeParam("Zoom (%)", 1, 500, 100);
    private RangeParam stretchParam = new RangeParam("Stretch (%)", 100, 999, 100);
    private RangeParam randomness = new RangeParam("Grid Randomness", 1, 100, 1);
    private IntChoiceParam gridType = IntChoiceParam.getGridTypeChoices("Grid Type", this.randomness);
    private IntChoiceParam typeParam = new IntChoiceParam("Type", new IntChoiceParam.Value[]{new IntChoiceParam.Value("Cells", 1), new IntChoiceParam.Value("Grid", 2), new IntChoiceParam.Value("Grid 2", 3)});
    private RangeParam tuneParam = new RangeParam("Tune Type", 0, 100, 0);
    private RangeParam bwParam = new RangeParam("Dark/Light Balance", -20, 20, 0);
    private AngleParam angleParam = new AngleParam("Angle", 0.0);
    private CellularFilter filter;

    public JHCells() {
        super("Cells");
        this.paramSet = new ParamSet(this.typeParam, this.tuneParam, this.gridType, this.randomness, this.gradientParam, this.bwParam, this.scaleParam, this.stretchParam, this.angleParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        float f;
        float f2;
        float f3;
        if (this.filter == null) {
            this.filter = new CellularFilter();
        }
        int n = this.scaleParam.getValue();
        float f4 = this.stretchParam.getValueAsPercentage();
        float f5 = (float)(this.angleParam.getValueInRadians() + 1.5707963267948966);
        int n2 = this.typeParam.getValue();
        float f6 = this.tuneParam.getValueAsPercentage();
        switch (n2) {
            case 1: {
                f3 = 1.0f - f6;
                f2 = f6;
                f = -f6 / 3.0f;
                break;
            }
            case 2: {
                f3 = -1.0f + f6;
                f2 = 1.0f;
                f = -f6 / 2.0f;
                break;
            }
            case 3: {
                f3 = -0.5f + f6;
                f2 = 0.5f - f6;
                f = 0.15f + f6 / 2.0f;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        float f7 = this.bwParam.getValueAsPercentage();
        f3 += f7;
        f2 += f7;
        f += f7;
        this.filter.setScale(n);
        this.filter.setStretch(f4);
        this.filter.setAngle(f5);
        this.filter.setF1(f3);
        this.filter.setF2(f2);
        this.filter.setF3(f);
        this.filter.setGridType(this.gridType.getValue());
        this.filter.setRandomness(this.randomness.getValueAsPercentage());
        this.filter.setColormap(this.gradientParam.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

