/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.FourColorFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.AdjustPanel;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.FourColorAdjustmentPanel;
import pixelitor.filters.gui.ParamSet;

public class JHFourColorGradient
extends FilterWithParametrizedGUI {
    private ColorParam northWestParam = new ColorParam("Northwest", Color.GREEN, false, false);
    private ColorParam northEastParam = new ColorParam("Northeast", Color.ORANGE, false, false);
    private ColorParam southWestParam = new ColorParam("Southwest", Color.BLUE, false, false);
    private ColorParam southEastParam = new ColorParam("Southeast", Color.RED, false, false);
    private FourColorFilter filter;

    public JHFourColorGradient() {
        super("Four Color Gradient");
        this.paramSet = new ParamSet(this.northWestParam, this.northEastParam, this.southWestParam, this.southEastParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new FourColorFilter();
        }
        this.filter.setColorNW(this.northWestParam.getColor().getRGB());
        this.filter.setColorNE(this.northEastParam.getColor().getRGB());
        this.filter.setColorSW(this.southWestParam.getColor().getRGB());
        this.filter.setColorSE(this.southEastParam.getColor().getRGB());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    @Override
    public AdjustPanel getAdjustPanel() {
        return new FourColorAdjustmentPanel(this);
    }
}

