/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.SmearFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHSmear
extends FilterWithParametrizedGUI {
    private RangeParam distance = new RangeParam("Distance", 0, 100, 0);
    private RangeParam density = new RangeParam("Density (%)", 0, 100, 50);
    private AngleParam angle = new AngleParam("Angle (only for lines)", 0.0);
    private RangeParam mix = new RangeParam("Opacity (%)", 0, 100, 50);
    private static IntChoiceParam.Value[] shapeChoices = new IntChoiceParam.Value[]{new IntChoiceParam.Value("Lines", 1), new IntChoiceParam.Value("Crosses", 0), new IntChoiceParam.Value("Circles", 2), new IntChoiceParam.Value("Squares", 3)};
    private IntChoiceParam shape = new IntChoiceParam("Shape", shapeChoices);
    private SmearFilter filter;

    public JHSmear() {
        super("Smear");
        this.paramSet = new ParamSet(this.distance, this.shape, this.density, this.angle, this.mix);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = this.distance.getValue();
        if (n == 0) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        if (this.filter == null) {
            this.filter = new SmearFilter();
        }
        this.filter.setDistance(n);
        this.filter.setDensity(this.density.getValueAsPercentage());
        this.filter.setAngle((float)this.angle.getValueInRadians());
        this.filter.setMix(this.mix.getValueAsPercentage());
        this.filter.setShape(this.shape.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

