/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.MarbleFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithSOParametrizedGUI;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.gui.ReseedNoiseAction;

public class JHTurbulentDistortion
extends FilterWithSOParametrizedGUI {
    private RangeParam scale = new RangeParam("Size", 2, 100, 20);
    private RangeParam amount = new RangeParam("Amount", 1, 100, 10);
    private RangeParam turbulence = new RangeParam("Turbulence", 1, 100, 50);
    private IntChoiceParam edgeAction = IntChoiceParam.getEdgeActionChoices();
    private IntChoiceParam interpolation = IntChoiceParam.getInterpolationChoices();
    private MarbleFilter filter;

    public JHTurbulentDistortion() {
        super("Turbulent Distortion");
        this.edgeAction.setDefaultChoice(IntChoiceParam.EDGE_CLAMP);
        this.paramSet = new ParamSet(this.scale, this.amount, this.turbulence, this.edgeAction, this.interpolation, this.showOriginalParam, new ReseedNoiseAction());
    }

    @Override
    public BufferedImage realTransform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new MarbleFilter();
        }
        this.filter.setTurbulence(this.turbulence.getValueAsPercentage());
        this.filter.setXScale(this.scale.getValue());
        this.filter.setYScale(this.amount.getValue());
        this.filter.setEdgeAction(this.edgeAction.getValue());
        this.filter.setInterpolation(this.interpolation.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

