/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.CircleFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHWrapAroundArc
extends FilterWithParametrizedGUI {
    private CircleFilter filter;
    private RangeParam radius = new RangeParam("Radius", 0, 500, 50);
    private RangeParam thickness = new RangeParam("Thickness", 0, 500, 150);
    private AngleParam rotateResult = new AngleParam("Rotate Result", 0.0);
    private RangeParam spread = new RangeParam("Spread", 0, 360, 180);
    private ImagePositionParam center = new ImagePositionParam("Center");
    private IntChoiceParam edgeAction = IntChoiceParam.getEdgeActionChoices();
    private IntChoiceParam interpolation = IntChoiceParam.getInterpolationChoices();

    public JHWrapAroundArc() {
        super("Wrap Around Arc");
        this.paramSet = new ParamSet(this.center, this.radius, this.thickness, this.rotateResult, this.spread, this.edgeAction, this.interpolation);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new CircleFilter();
        }
        this.filter.setCentreX(this.center.getRelativeX());
        this.filter.setCentreY(this.center.getRelativeY());
        this.filter.setRadius(this.radius.getValue());
        this.filter.setHeight(this.thickness.getValue());
        this.filter.setAngle((float)this.rotateResult.getValueInIntuitiveRadians());
        this.filter.setSpreadAngle(this.spread.getValueInRadians());
        this.filter.setInterpolation(this.interpolation.getValue());
        this.filter.setEdgeAction(this.edgeAction.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

