/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.lookup;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;
import pixelitor.utils.ImageUtils;

public class FastLookupOp
implements BufferedImageOp {
    private ShortLookupTable lookupTable;

    public FastLookupOp(ShortLookupTable shortLookupTable) {
        this.lookupTable = shortLookupTable;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        boolean bl = ImageUtils.hasPackedIntArray(bufferedImage);
        if (bl) {
            DataBufferInt dataBufferInt;
            int[] nArray;
            boolean bl2 = !bufferedImage.isAlphaPremultiplied();
            DataBufferInt dataBufferInt2 = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
            int[] nArray2 = dataBufferInt2.getData();
            int n = nArray2.length;
            if (n != (nArray = (dataBufferInt = (DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData()).length) {
                throw new IllegalArgumentException("src and dest are not the same size");
            }
            short[][] sArray = this.lookupTable.getTable();
            for (int i = 0; i < n; ++i) {
                int n2 = nArray2[i];
                int n3 = n2 >>> 24 & 0xFF;
                int n4 = n2 >>> 16 & 0xFF;
                int n5 = n2 >>> 8 & 0xFF;
                int n6 = n2 & 0xFF;
                if (n3 == 255 || bl2) {
                    n4 = sArray[0][n4];
                    n5 = sArray[1][n5];
                    n6 = sArray[2][n6];
                } else if (n3 == 0) {
                    n4 = 0;
                    n5 = 0;
                    n6 = 0;
                } else {
                    float f = 255.0f / (float)n3;
                    int n7 = (int)((float)n4 * f);
                    int n8 = (int)((float)n5 * f);
                    int n9 = (int)((float)n6 * f);
                    if (n7 > 255) {
                        n7 = 255;
                    }
                    if (n8 > 255) {
                        n8 = 255;
                    }
                    if (n9 > 255) {
                        n9 = 255;
                    }
                    n7 = sArray[0][n7];
                    n8 = sArray[1][n8];
                    n9 = sArray[2][n9];
                    float f2 = (float)n3 * 0.003921569f;
                    n4 = (int)((float)n7 * f2);
                    n5 = (int)((float)n8 * f2);
                    n6 = (int)((float)n9 * f2);
                    n4 = ImageUtils.limitTo8Bits(n4);
                    n5 = ImageUtils.limitTo8Bits(n5);
                    n6 = ImageUtils.limitTo8Bits(n6);
                }
                nArray[i] = n3 << 24 | n4 << 16 | n5 << 8 | n6;
            }
        } else {
            LookupOp lookupOp = new LookupOp(this.lookupTable, null);
            lookupOp.filter(bufferedImage, bufferedImage2);
        }
        return bufferedImage2;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return null;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        return null;
    }

    @Override
    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        return null;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }
}

