/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.lookup;

public final class LuminanceLookup {
    private static final int TABLE_SIZE = 256;
    private static final float RED_CONTRIBUTION = 0.2126f;
    private static final float GREEN_CONTRIBUTION = 0.7152f;
    private static final float BLUE_CONTRIBUTION = 0.0722f;
    private static final float[] redLuminanceTable = new float[256];
    private static final float[] greenLuminanceTable = new float[256];
    private static final float[] blueLuminanceTable = new float[256];

    private LuminanceLookup() {
    }

    public static int getLuminosity(int n, int n2, int n3) {
        return (int)(redLuminanceTable[n] + greenLuminanceTable[n2] + blueLuminanceTable[n3]);
    }

    public static int getLuminosity(int n) {
        int n2 = n >>> 16 & 0xFF;
        int n3 = n >>> 8 & 0xFF;
        int n4 = n & 0xFF;
        return (int)(redLuminanceTable[n2] + greenLuminanceTable[n3] + blueLuminanceTable[n4]);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            LuminanceLookup.redLuminanceTable[i] = (float)i * 0.2126f;
            LuminanceLookup.greenLuminanceTable[i] = (float)i * 0.7152f;
            LuminanceLookup.blueLuminanceTable[i] = (float)i * 0.0722f;
        }
    }
}

