/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.lookup;

import java.awt.image.BufferedImage;
import pixelitor.filters.Filter;
import pixelitor.filters.lookup.LuminanceLookup;
import pixelitor.utils.ImageUtils;

public class Luminosity
extends Filter {
    public Luminosity() {
        super("Luminosity");
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        int[] nArray2 = ImageUtils.getPixelsAsArray(bufferedImage2);
        for (int i = 0; i < nArray2.length; ++i) {
            int n = nArray[i];
            int n2 = n & 0xFF000000;
            if (n2 == 0) {
                nArray2[i] = 0;
                continue;
            }
            int n3 = LuminanceLookup.getLuminosity(n);
            nArray2[i] = n2 | n3 << 16 | n3 << 8 | n3;
        }
        return bufferedImage2;
    }

    @Override
    public void randomizeSettings() {
    }
}

