/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pixelitor.history.History;
import pixelitor.history.PixelitorEdit;
import pixelitor.layers.BlendingMode;
import pixelitor.layers.Layer;

public class LayerBlendingEdit
extends PixelitorEdit {
    private Layer layer;
    private BlendingMode backupBlendingMode;

    public LayerBlendingEdit(Layer layer, BlendingMode blendingMode) {
        super(layer.getComposition(), "Blending Mode Change");
        this.layer = layer;
        this.backupBlendingMode = blendingMode;
        layer.getComposition().setDirty(true);
    }

    @Override
    public void die() {
        super.die();
        this.layer = null;
        this.backupBlendingMode = null;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.swapBlendingModes();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.swapBlendingModes();
    }

    private void swapBlendingModes() {
        BlendingMode blendingMode = this.layer.getBlendingMode();
        this.layer.setBlendingMode(this.backupBlendingMode, true, false);
        this.backupBlendingMode = blendingMode;
        History.postEdit(this);
    }

    @Override
    public boolean canRepeat() {
        return false;
    }
}

