/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pixelitor.Composition;
import pixelitor.history.History;
import pixelitor.history.PixelitorEdit;
import pixelitor.layers.ImageLayer;
import pixelitor.layers.Layer;
import pixelitor.selection.Selection;

public class OneLayerUndoableEdit
extends PixelitorEdit {
    private BufferedImage backupImage;
    private boolean saveSelection;
    private int backupTranslationX;
    private int backupTranslationY;
    private int backupCanvasWidth;
    private int backupCanvasHeight;
    private Shape backupShape;

    private OneLayerUndoableEdit(String string, BufferedImage bufferedImage, Composition composition, boolean bl) {
        super(composition, string);
        Selection selection;
        this.backupImage = bufferedImage;
        this.saveSelection = bl;
        if (bl && (selection = composition.getSelection()) != null) {
            this.backupShape = selection.getShape();
        }
        int n = composition.getNrLayers();
        if (bufferedImage != null) {
            if (n != 1) {
                throw new IllegalArgumentException("(backupImage != null, nrLayers = " + n);
            }
            ImageLayer imageLayer = (ImageLayer)composition.getActiveLayer();
            this.backupTranslationX = imageLayer.getTranslationX();
            this.backupTranslationY = imageLayer.getTranslationY();
            this.backupCanvasWidth = composition.getCanvasWidth();
            this.backupCanvasHeight = composition.getCanvasHeight();
        }
    }

    @Override
    public boolean canUndo() {
        if (this.backupImage == null) {
            return false;
        }
        return super.canUndo();
    }

    @Override
    public boolean canRedo() {
        if (this.backupImage == null) {
            return false;
        }
        return super.canRedo();
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.swapImages(this.getPresentationName() + " UNDO");
        if (this.saveSelection && this.backupShape != null) {
            this.comp.createSelectionFromShape(this.backupShape);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.saveSelection) {
            this.comp.deselect(false);
        }
        this.swapImages(this.getPresentationName() + " REDO");
    }

    private void swapImages(String string) {
        if (this.comp.getNrLayers() != 1) {
            throw new IllegalStateException("nr of layers = " + this.comp.getNrLayers());
        }
        ImageLayer imageLayer = (ImageLayer)this.comp.getActiveLayer();
        BufferedImage bufferedImage = imageLayer.getImageOrSubImageIfSelected(false, true);
        int n = imageLayer.getTranslationX();
        int n2 = imageLayer.getTranslationY();
        int n3 = this.comp.getCanvasWidth();
        int n4 = this.comp.getCanvasHeight();
        this.comp.getActiveImageLayer().changeImageUndoRedo(this.backupImage);
        if (!this.comp.hasSelection()) {
            imageLayer.setTranslationX(this.backupTranslationX);
            imageLayer.setTranslationY(this.backupTranslationY);
            this.comp.updateCanvasSize(this.backupCanvasWidth, this.backupCanvasHeight);
        }
        this.backupImage = bufferedImage;
        this.backupTranslationX = n;
        this.backupTranslationY = n2;
        this.backupCanvasWidth = n3;
        this.backupCanvasHeight = n4;
        History.postEdit(this);
    }

    public static void createAndAddToHistory(Composition composition, String string, boolean bl, boolean bl2) {
        int n = composition.getNrLayers();
        if (n > 1) {
            History.addEdit(new OneLayerUndoableEdit(string, null, composition, bl2));
        } else {
            BufferedImage bufferedImage = null;
            Layer layer = composition.getLayer(0);
            if (layer instanceof ImageLayer) {
                ImageLayer imageLayer = (ImageLayer)layer;
                bufferedImage = bl ? imageLayer.getImageOrSubImageIfSelected(false, true) : imageLayer.getBufferedImage();
            }
            History.addEdit(new OneLayerUndoableEdit(string, bufferedImage, composition, bl2));
        }
    }
}

