/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pixelitor.Composition;
import pixelitor.history.FadeableEdit;
import pixelitor.history.History;
import pixelitor.layers.ImageLayer;
import pixelitor.selection.Selection;
import pixelitor.utils.ImageUtils;

public class PartialImageEdit
extends FadeableEdit {
    private Rectangle saveRectangle;
    private boolean canRepeat;
    private Raster backupRaster;
    private ImageLayer layer;

    public PartialImageEdit(String string, Composition composition, BufferedImage bufferedImage, Rectangle rectangle, boolean bl) {
        super(composition, string);
        this.canRepeat = bl;
        composition.setDirty(true);
        this.layer = (ImageLayer)composition.getActiveLayer();
        this.saveRectangle = rectangle;
        this.backupRaster = bufferedImage.getData(this.saveRectangle);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.swapRasters();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.swapRasters();
    }

    private void swapRasters() {
        Raster raster;
        BufferedImage bufferedImage = this.layer.getBufferedImage();
        try {
            raster = bufferedImage.getData(this.saveRectangle);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("PartialImageEdit.swapRasters saveRectangle = " + this.saveRectangle);
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            System.out.println("PartialImageEdit.swapRasters width = " + n + ", height = " + n2);
            throw arrayIndexOutOfBoundsException;
        }
        bufferedImage.setData(this.backupRaster);
        this.backupRaster = raster;
        this.comp.imageChanged(true, true);
        History.postEdit(this);
    }

    @Override
    public void die() {
        super.die();
        this.backupRaster = null;
    }

    @Override
    public boolean canRepeat() {
        return this.canRepeat;
    }

    @Override
    public BufferedImage getBackupImage() {
        BufferedImage bufferedImage = this.layer.getBufferedImage();
        BufferedImage bufferedImage2 = ImageUtils.copyImage(bufferedImage);
        bufferedImage2.setData(this.backupRaster);
        Selection selection = this.layer.getComposition().getSelection();
        if (selection != null) {
            bufferedImage2 = this.layer.getSelectionSizedPartFrom(bufferedImage2, selection, true);
        }
        return bufferedImage2;
    }
}

