/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.io;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import pixelitor.ExceptionHandler;

public final class JpegOutput {
    private JpegOutput() {
    }

    public static void writeJPG(BufferedImage bufferedImage, File file, float f) throws IOException {
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
        JpegOutput.writeJPGtoStream(bufferedImage, imageOutputStream, f);
    }

    public static ImageWithSize writeJPGtoPreviewImage(BufferedImage bufferedImage, float f) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32768);
        BufferedImage bufferedImage2 = null;
        byte[] byArray = null;
        try {
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
            JpegOutput.writeJPGtoStream(bufferedImage, imageOutputStream, f);
            byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            bufferedImage2 = ImageIO.read(byteArrayInputStream);
        }
        catch (IOException iOException) {
            ExceptionHandler.showExceptionDialog(iOException);
        }
        int n = byArray.length;
        return new ImageWithSize(bufferedImage2, n);
    }

    private static void writeJPGtoStream(BufferedImage bufferedImage, ImageOutputStream imageOutputStream, float f) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpg");
        if (!iterator.hasNext()) {
            throw new IllegalStateException("No JPG writers found");
        }
        ImageWriter imageWriter = iterator.next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(f);
        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(null, iIOImage, imageWriteParam);
        imageOutputStream.flush();
        imageOutputStream.close();
    }

    static class ImageWithSize {
        BufferedImage image;
        int size;

        ImageWithSize(BufferedImage bufferedImage, int n) {
            this.image = bufferedImage;
            this.size = n;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public int getSize() {
            return this.size;
        }
    }
}

