/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.layers;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pixelitor.Composition;
import pixelitor.ConsistencyChecks;
import pixelitor.ExceptionHandler;
import pixelitor.filters.comp.Flip;
import pixelitor.history.History;
import pixelitor.history.ImageEdit;
import pixelitor.history.TranslateEdit;
import pixelitor.layers.BlendingMode;
import pixelitor.layers.ContentLayer;
import pixelitor.layers.Layer;
import pixelitor.layers.TmpDrawingLayer;
import pixelitor.selection.Selection;
import pixelitor.tools.Tools;
import pixelitor.utils.ImageUtils;
import pixelitor.utils.Utils;
import pixelitor.utils.debug.ImageLayerNode;

public class ImageLayer
extends ContentLayer {
    private static final long serialVersionUID = 2L;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_PREVIEWING_NOT_CHANGED = 1;
    private static final int STATE_PREVIEWING_CHANGED = 2;
    private transient int state = 0;
    private transient BufferedImage bufferedImage = null;
    private transient TmpDrawingLayer tmpDrawingLayer;
    private transient BufferedImage backupForPreviewBufferedImage = null;

    public ImageLayer(Composition composition, BufferedImage bufferedImage, String string) {
        super(composition, string == null ? composition.generateNewLayerName() : string);
        if (bufferedImage == null) {
            throw new IllegalArgumentException("bufferedImage is null");
        }
        this.setBufferedImage(bufferedImage, true);
    }

    public ImageLayer(Composition composition, BufferedImage bufferedImage, String string, int n, int n2) {
        super(composition, string);
        int n3;
        if (bufferedImage == null) {
            throw new IllegalArgumentException("bufferedImage is null");
        }
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        boolean bl = n4 < n || n5 < n2;
        boolean bl2 = n4 > n;
        boolean bl3 = n5 > n2;
        BufferedImage bufferedImage2 = bufferedImage;
        if (bl) {
            n3 = Math.max(n, n4);
            int n6 = Math.max(n2, n5);
            bufferedImage2 = new BufferedImage(n3, n6, 3);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            int n7 = Math.max((n - n4) / 2, 0);
            int n8 = Math.max((n2 - n5) / 2, 0);
            graphics2D.drawImage((Image)bufferedImage, n7, n8, null);
            graphics2D.dispose();
        }
        this.setBufferedImage(bufferedImage2, true);
        if (bl2) {
            n3 = -(n4 - n) / 2;
            this.setTranslationX(n3);
        }
        if (bl3) {
            n3 = -(n5 - n2) / 2;
            this.setTranslationY(n3);
        }
    }

    public ImageLayer(Composition composition, String string, int n, int n2) {
        super(composition, string == null ? composition.generateNewLayerName() : string);
        this.setBufferedImage(new BufferedImage(n, n2, 3), true);
    }

    @Override
    public Layer duplicate() {
        BufferedImage bufferedImage = ImageUtils.copyImage(this.bufferedImage);
        ImageLayer imageLayer = new ImageLayer(this.comp, bufferedImage, this.getDuplicateLayerName());
        imageLayer.setOpacity(this.opacity, false, true);
        imageLayer.setTranslationX(this.translationX);
        imageLayer.setTranslationY(this.translationY);
        imageLayer.setBlendingMode(this.blendingMode, false, true);
        return imageLayer;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage, boolean bl) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("newImage is null");
        }
        assert (Utils.checkRasterMinimum(bufferedImage));
        Selection selection = this.comp.getSelection();
        if (bl || selection == null) {
            this.bufferedImage = bufferedImage;
        } else {
            Shape shape = selection.getShape();
            if (shape != null) {
                Graphics2D graphics2D = this.bufferedImage.createGraphics();
                graphics2D.translate(-this.getTranslationX(), -this.getTranslationY());
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.setClip(shape);
                Rectangle rectangle = shape.getBounds();
                graphics2D.drawImage((Image)bufferedImage, rectangle.x, rectangle.y, null);
                graphics2D.dispose();
            } else {
                this.bufferedImage = bufferedImage;
            }
        }
        this.comp.imageChanged(false, false);
    }

    public void startPreviewing() {
        this.backupForPreviewBufferedImage = this.getImageOrSubImageIfSelected(true, true);
        this.state = 1;
    }

    public void startNewPreviewFromDialog() {
        this.restoreOriginalFromPreviewBackup();
    }

    public void cancelPreviewing() {
        this.restoreOriginalFromPreviewBackup();
        this.state = 0;
        this.getComposition().getIC().repaint();
    }

    private void restoreOriginalFromPreviewBackup() {
        if (this.backupForPreviewBufferedImage == null) {
            throw new IllegalStateException("backupForPreviewBufferedImage is null");
        }
        this.setBufferedImage(this.backupForPreviewBufferedImage, false);
    }

    public void finishFilterWithPreview(String string) {
        assert (this.state != 0);
        if (this.state == 2) {
            ImageEdit imageEdit = new ImageEdit(string, this.comp, this.backupForPreviewBufferedImage, true);
            History.addEdit(imageEdit);
        }
        this.state = 0;
    }

    public boolean changePreviewImage(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("img == null");
        }
        if (bufferedImage == this.bufferedImage) {
            assert (this.state != 0);
            boolean bl = this.state == 1;
            this.state = 1;
            return !bl;
        }
        this.setBufferedImage(bufferedImage, false);
        this.state = 2;
        return true;
    }

    public void changeImageSimpleFilterFinished(BufferedImage bufferedImage, String string) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("img == null");
        }
        assert (bufferedImage != this.bufferedImage);
        assert (this.state == 0);
        BufferedImage bufferedImage2 = this.getImageOrSubImageIfSelected(false, true);
        this.setBufferedImage(bufferedImage, false);
        if (bufferedImage2 == this.bufferedImage) {
            throw new IllegalStateException("imageForUndo == bufferedImage");
        }
        assert (bufferedImage2 != null);
        ImageEdit imageEdit = new ImageEdit(string, this.comp, bufferedImage2, true);
        History.addEdit(imageEdit);
    }

    public void changeImageUndoRedo(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("img == null");
        }
        assert (bufferedImage != this.bufferedImage);
        assert (this.state == 0);
        this.setBufferedImage(bufferedImage, false);
    }

    public String toString() {
        ImageLayerNode imageLayerNode = new ImageLayerNode(this);
        return imageLayerNode.toDetailedString();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.translationX, this.translationY, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
    }

    public boolean checkForLayerEnlargement() {
        Rectangle rectangle = this.comp.getCanvasBounds();
        Rectangle rectangle2 = this.getBounds();
        boolean bl = !rectangle2.contains(rectangle);
        return bl;
    }

    public void enlargeLayer() {
        try {
            if (this.translationX >= 0) {
                if (this.translationY >= 0) {
                    this.enlargeNW();
                } else {
                    this.enlargeSW();
                }
            } else if (this.translationY >= 0) {
                this.enlargeNE();
            } else {
                this.enlargeSE();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ExceptionHandler.showOutOfMemoryDialog();
        }
    }

    private void enlargeSE() {
        BufferedImage bufferedImage = new BufferedImage(this.bufferedImage.getWidth() - this.translationX, this.bufferedImage.getHeight() - this.translationY, this.bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.bufferedImage, 0, 0, null);
        graphics2D.dispose();
        this.setBufferedImage(bufferedImage, true);
    }

    private void enlargeNE() {
        BufferedImage bufferedImage = new BufferedImage(this.bufferedImage.getWidth() - this.translationX, this.bufferedImage.getHeight() + this.translationY, this.bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.bufferedImage, 0, this.translationY, null);
        graphics2D.dispose();
        this.setBufferedImage(bufferedImage, true);
        this.translationY = 0;
    }

    private void enlargeSW() {
        BufferedImage bufferedImage = new BufferedImage(this.bufferedImage.getWidth() + this.translationX, this.bufferedImage.getHeight() - this.translationY, this.bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.bufferedImage, this.translationX, 0, null);
        graphics2D.dispose();
        this.setBufferedImage(bufferedImage, true);
        this.translationX = 0;
    }

    private void enlargeNW() {
        BufferedImage bufferedImage = new BufferedImage(this.bufferedImage.getWidth() + this.translationX, this.bufferedImage.getHeight() + this.translationY, this.bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.bufferedImage, this.translationX, this.translationY, null);
        graphics2D.dispose();
        this.setBufferedImage(bufferedImage, true);
        this.translationX = 0;
        this.translationY = 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        ImageUtils.serializeImage(objectOutputStream, this.bufferedImage);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setBufferedImage(ImageUtils.deserializeImage(objectInputStream), true);
    }

    public BufferedImage getImageForFilterDialogs() {
        Selection selection = this.comp.getSelection();
        if (selection == null) {
            return this.bufferedImage;
        }
        Rectangle rectangle = selection.getShapeBounds();
        return this.bufferedImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void flip(Flip.Direction direction) {
        int n;
        int n2;
        int n3 = -this.getTranslationX();
        int n4 = -this.getTranslationY();
        BufferedImage bufferedImage = this.getImageOrSubImageIfSelected(false, false);
        int n5 = this.comp.getCanvasWidth();
        int n6 = this.comp.getCanvasHeight();
        int n7 = bufferedImage.getWidth();
        int n8 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n7, n8, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        if (direction == Flip.Direction.HORIZONTAL) {
            graphics2D.translate(n7, 0);
            graphics2D.scale(-1.0, 1.0);
            n2 = n7 - n5 - n3;
            n = n4;
        } else {
            graphics2D.translate(0, n8);
            graphics2D.scale(1.0, -1.0);
            n2 = n3;
            n = n8 - n6 - n4;
        }
        graphics2D.drawImage(bufferedImage, 0, 0, n7, n8, null);
        graphics2D.dispose();
        if (!this.comp.hasSelection()) {
            this.setTranslationX(-n2);
            this.setTranslationY(-n);
        }
        this.setBufferedImage(bufferedImage2, false);
    }

    @Override
    public void rotate(int n) {
        int n2;
        int n3;
        int n4 = -this.getTranslationX();
        int n5 = -this.getTranslationY();
        int n6 = 0;
        int n7 = 0;
        BufferedImage bufferedImage = this.getImageOrSubImageIfSelected(false, false);
        int n8 = bufferedImage.getWidth();
        int n9 = bufferedImage.getHeight();
        int n10 = this.comp.getCanvasWidth();
        int n11 = this.comp.getCanvasHeight();
        if (n == 90) {
            n6 = n9 - n5 - n11;
            n7 = n4;
        } else if (n == 270) {
            n6 = n5;
            n7 = n8 - n4 - n10;
        } else if (n == 180) {
            n6 = n8 - n10 - n4;
            n7 = n9 - n11 - n5;
        }
        if (n == 90 || n == 270) {
            n3 = n9;
            n2 = n8;
        } else {
            n3 = n8;
            n2 = n9;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n3, n2, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (n == 90) {
            graphics2D.translate(n9, 0);
        } else if (n == 180) {
            graphics2D.translate(n8, n9);
        } else if (n == 270) {
            graphics2D.translate(0, n8);
        }
        graphics2D.rotate(Math.toRadians(n));
        graphics2D.drawImage(bufferedImage, 0, 0, n8, n9, null);
        graphics2D.dispose();
        if (!this.comp.hasSelection()) {
            this.setTranslationX(-n6);
            this.setTranslationY(-n7);
        }
        this.setBufferedImage(bufferedImage2, false);
    }

    @Override
    public void mergeDownOn(ImageLayer imageLayer) {
        int n = this.getTranslationX();
        int n2 = this.getTranslationY();
        BufferedImage bufferedImage = imageLayer.getBufferedImage();
        int n3 = imageLayer.getTranslationX();
        int n4 = imageLayer.getTranslationY();
        BufferedImage bufferedImage2 = this.getBufferedImage();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n5 = n - n3;
        int n6 = n2 - n4;
        Composite composite = this.blendingMode.getComposite(this.opacity);
        graphics2D.setComposite(composite);
        graphics2D.drawImage((Image)bufferedImage2, n5, n6, null);
        graphics2D.dispose();
    }

    @Override
    public void paintLayerOnGraphics(Graphics2D graphics2D, boolean bl) {
        this.setupDrawingComposite(graphics2D, bl);
        if (this.tmpDrawingLayer == null) {
            if (Tools.isShapesDrawing() && this.isActiveLayer()) {
                BufferedImage bufferedImage = this.createCompositionSizedTmpImage();
                Graphics2D graphics2D2 = bufferedImage.createGraphics();
                graphics2D2.drawImage((Image)this.bufferedImage, this.getTranslationX(), this.getTranslationY(), null);
                this.comp.setSelectionClipping(graphics2D2, null);
                Tools.SHAPES.paintOverLayer(graphics2D2);
                graphics2D2.dispose();
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                bufferedImage.flush();
            } else {
                graphics2D.drawImage((Image)this.bufferedImage, this.getTranslationX(), this.getTranslationY(), null);
            }
        } else if (this.blendingMode == BlendingMode.NORMAL && this.opacity > 0.999f) {
            graphics2D.drawImage((Image)this.bufferedImage, this.getTranslationX(), this.getTranslationY(), null);
            this.tmpDrawingLayer.paintLayer(graphics2D, 0, 0);
        } else {
            BufferedImage bufferedImage = ImageUtils.copyImage(this.bufferedImage);
            Graphics2D graphics2D3 = bufferedImage.createGraphics();
            this.tmpDrawingLayer.paintLayer(graphics2D3, -this.getTranslationX(), -this.getTranslationY());
            graphics2D3.dispose();
            graphics2D.drawImage((Image)bufferedImage, this.getTranslationX(), this.getTranslationY(), null);
        }
    }

    public TmpDrawingLayer createTmpDrawingLayer(Composite composite, boolean bl) {
        this.tmpDrawingLayer = new TmpDrawingLayer(this, composite, bl);
        return this.tmpDrawingLayer;
    }

    public void mergeTmpDrawingImageDown() {
        if (this.tmpDrawingLayer == null) {
            return;
        }
        Graphics2D graphics2D = this.bufferedImage.createGraphics();
        this.tmpDrawingLayer.paintLayer(graphics2D, -this.getTranslationX(), -this.getTranslationY());
        graphics2D.dispose();
        this.tmpDrawingLayer.dispose();
        this.tmpDrawingLayer = null;
    }

    public BufferedImage createCompositionSizedTmpImage() {
        return new BufferedImage(this.comp.getCanvasWidth(), this.comp.getCanvasHeight(), this.bufferedImage.getType());
    }

    public BufferedImage createCompositionSizedSubImage() {
        BufferedImage bufferedImage;
        int n = -this.getTranslationX();
        int n2 = -this.getTranslationY();
        int n3 = this.comp.getCanvasWidth();
        int n4 = this.comp.getCanvasHeight();
        assert (ConsistencyChecks.translationCheck(this.comp));
        try {
            bufferedImage = this.bufferedImage.getSubimage(n, n2, n3, n4);
        }
        catch (RasterFormatException rasterFormatException) {
            System.out.println("ImageLayer.createCompositionSizedSubImage x = " + n + ", y = " + n2 + ", canvasWidth = " + n3 + ", canvasHeight = " + n4);
            WritableRaster writableRaster = this.bufferedImage.getRaster();
            int n5 = writableRaster.getMinX();
            int n6 = writableRaster.getMinY();
            System.out.println("ImageLayer.createCompositionSizedSubImage minX = " + n5 + ", minY = " + n6);
            throw rasterFormatException;
        }
        return bufferedImage;
    }

    public BufferedImage getImageOrSubImageIfSelected(boolean bl, boolean bl2) {
        Selection selection = this.comp.getSelection();
        if (selection == null) {
            if (bl) {
                return ImageUtils.copyImage(this.bufferedImage);
            }
            return this.bufferedImage;
        }
        return this.getSelectionSizedPartFrom(this.bufferedImage, selection, bl2);
    }

    public BufferedImage getSelectionSizedPartFrom(BufferedImage bufferedImage, Selection selection, boolean bl) {
        Rectangle rectangle = selection.getShapeBounds();
        rectangle.translate(-this.getTranslationX(), -this.getTranslationY());
        Rectangle rectangle2 = new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        rectangle = rectangle.intersection(rectangle2);
        if (rectangle.isEmpty()) {
            if (bl) {
                return ImageUtils.copyImage(bufferedImage);
            }
            return bufferedImage;
        }
        if (bl) {
            return ImageUtils.copyAndTranslateSubimage(bufferedImage, rectangle);
        }
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return bufferedImage2;
    }

    public void cropToCanvasSize() {
        int n = this.bufferedImage.getWidth();
        int n2 = this.bufferedImage.getHeight();
        int n3 = this.comp.getCanvasWidth();
        int n4 = this.comp.getCanvasHeight();
        if (n > n3 || n2 > n4) {
            BufferedImage bufferedImage = ImageUtils.crop(this.bufferedImage, -this.getTranslationX(), -this.getTranslationY(), n3, n4);
            BufferedImage bufferedImage2 = this.bufferedImage;
            this.setBufferedImage(bufferedImage, true);
            bufferedImage2.flush();
            this.setTranslationX(0);
            this.setTranslationY(0);
        }
    }

    @Override
    public void enlargeCanvas(int n, int n2, int n3, int n4) {
        int n5 = this.bufferedImage.getWidth();
        int n6 = this.bufferedImage.getHeight();
        int n7 = this.comp.getCanvasWidth();
        int n8 = this.comp.getCanvasHeight();
        int n9 = n5 + n2 + n4;
        int n10 = n6 + n + n3;
        int n11 = n4;
        int n12 = n;
        int n13 = this.getTranslationX();
        int n14 = this.getTranslationY();
        BufferedImage bufferedImage = new BufferedImage(n9, n10, this.bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.bufferedImage, n11, n12, null);
        graphics2D.dispose();
        this.bufferedImage.flush();
        this.bufferedImage = bufferedImage;
        this.setTranslationX(n13);
        this.setTranslationY(n14);
    }

    @Override
    TranslateEdit createTranslateEdit(int n, int n2) {
        TranslateEdit translateEdit = null;
        boolean bl = this.checkForLayerEnlargement();
        translateEdit = bl ? new TranslateEdit(this, this.getBufferedImage(), n, n2) : new TranslateEdit(this, null, n, n2);
        if (bl) {
            this.enlargeLayer();
        }
        return translateEdit;
    }

    @Override
    public void resize(int n, int n2, boolean bl) {
        Rectangle rectangle = this.comp.getCanvasBounds();
        BufferedImage bufferedImage = this.getBufferedImage();
        Rectangle rectangle2 = this.getBounds();
        boolean bl2 = !rectangle.contains(rectangle2);
        int n3 = n;
        int n4 = n2;
        double d = 1.0;
        double d2 = 1.0;
        if (bl2) {
            d = (double)n / (double)this.comp.getCanvasWidth();
            d2 = (double)n2 / (double)this.comp.getCanvasHeight();
            n3 = (int)((double)bufferedImage.getWidth() * d);
            n4 = (int)((double)bufferedImage.getHeight() * d2);
        }
        BufferedImage bufferedImage2 = ImageUtils.getFasterScaledInstance(bufferedImage, n3, n4, RenderingHints.VALUE_INTERPOLATION_BICUBIC, bl);
        this.setBufferedImage(bufferedImage2, true);
        if (bl2) {
            this.setTranslationX((int)((double)this.getTranslationX() * d));
            this.setTranslationY((int)((double)this.getTranslationY() * d2));
        }
    }

    @Override
    public void crop(Rectangle rectangle) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        BufferedImage bufferedImage = this.getBufferedImage();
        int n3 = this.getTranslationX();
        int n4 = this.getTranslationY();
        int n5 = rectangle.x - n3;
        int n6 = rectangle.y - n4;
        BufferedImage bufferedImage2 = ImageUtils.crop(bufferedImage, n5, n6, n, n2);
        this.setBufferedImage(bufferedImage2, true);
        this.setTranslationX(0);
        this.setTranslationY(0);
    }
}

