/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.layers;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.layers.BlendingMode;
import pixelitor.layers.Layer;
import pixelitor.layers.LayerChangeListener;
import pixelitor.utils.BlendingModePanel;
import pixelitor.utils.ImageSwitchListener;

public class LayerBlendingModePanel
extends BlendingModePanel
implements ImageSwitchListener,
LayerChangeListener {
    private boolean userInteractionChange = true;
    public static final LayerBlendingModePanel INSTANCE = new LayerBlendingModePanel();

    private LayerBlendingModePanel() {
        super(false);
        AppLogic.addImageChangeListener(this);
        AppLogic.addLayerChangeListener(this);
        this.opacityDDSlider.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LayerBlendingModePanel.this.userInteractionChange) {
                    LayerBlendingModePanel.this.opacityChanged();
                }
            }
        });
        this.blendingModeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LayerBlendingModePanel.this.userInteractionChange) {
                    LayerBlendingModePanel.this.blendingModeChanged();
                }
            }
        });
        this.setEnabled(false);
    }

    private void opacityChanged() {
        Layer layer;
        Composition composition = AppLogic.getActiveComp();
        if (composition != null && (layer = composition.getActiveLayer()) != null) {
            float f = this.getOpacity();
            layer.setOpacity(f, false, true);
        }
    }

    private void blendingModeChanged() {
        Layer layer;
        Composition composition = AppLogic.getActiveComp();
        if (composition != null && (layer = composition.getActiveLayer()) != null) {
            BlendingMode blendingMode = this.getBlendingMode();
            layer.setBlendingMode(blendingMode, false, true);
        }
    }

    @Override
    public void noOpenImageAnymore() {
        this.setEnabled(false);
    }

    @Override
    public void newImageOpened() {
        this.setEnabled(true);
    }

    @Override
    public void activeCompositionHasChanged(Composition composition) {
        this.setEnabled(true);
    }

    @Override
    public void activeCompLayerCountChanged(Composition composition, int n) {
    }

    @Override
    public void layerOrderChanged(Composition composition) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activeLayerChanged(Layer layer) {
        float f = layer.getOpacity();
        int n = (int)(f * 100.0f);
        BlendingMode blendingMode = layer.getBlendingMode();
        try {
            this.userInteractionChange = false;
            this.opacityDDSlider.setValue(n);
            this.blendingModeCombo.setSelectedItem((Object)blendingMode);
        }
        finally {
            this.userInteractionChange = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlendingModeNotUI(BlendingMode blendingMode) {
        try {
            this.userInteractionChange = false;
            this.blendingModeCombo.setSelectedItem((Object)blendingMode);
        }
        finally {
            this.userInteractionChange = true;
        }
    }
}

