/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.layers;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import pixelitor.utils.ImageUtils;

public class LayerMask {
    BufferedImage transparentImage;
    BufferedImage bwImage;
    private static ColorModel transparencyColorModel;

    public LayerMask(BufferedImage bufferedImage) {
        this.bwImage = bufferedImage;
        this.initFromBWImage(bufferedImage);
    }

    public void initFromBWImage(BufferedImage bufferedImage) {
        assert (bufferedImage.getColorModel() != transparencyColorModel);
        if (bufferedImage.getType() != 10) {
            bufferedImage = ImageUtils.convertToGrayScaleImage(bufferedImage);
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        this.transparentImage = new BufferedImage(transparencyColorModel, writableRaster, false, null);
    }

    public BufferedImage getTransparentImage() {
        return this.transparentImage;
    }

    public BufferedImage getBwImage() {
        return this.bwImage;
    }

    static {
        byte[] byArray = new byte[256];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)i;
        }
        transparencyColorModel = new IndexColorModel(8, 256, byArray, byArray, byArray, byArray);
    }
}

