/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.layers;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.layers.Layer;
import pixelitor.layers.LayerChangeListener;
import pixelitor.utils.IconUtils;
import pixelitor.utils.ImageSwitchListener;

public class LayerUpAction
extends AbstractAction
implements ImageSwitchListener,
LayerChangeListener {
    public static final LayerUpAction INSTANCE = new LayerUpAction();

    private LayerUpAction() {
        super("Raise Layer", IconUtils.getNorthArrowIcon());
        this.setEnabled(false);
        AppLogic.addImageChangeListener(this);
        AppLogic.addLayerChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Composition composition = AppLogic.getActiveComp();
        composition.moveActiveLayerUp();
    }

    @Override
    public void noOpenImageAnymore() {
        this.setEnabled(false);
    }

    @Override
    public void newImageOpened() {
        Composition composition = AppLogic.getActiveComp();
        this.checkIndex(composition);
    }

    private void checkIndex(Composition composition) {
        if (composition != null) {
            int n = composition.getNrLayers();
            int n2 = composition.getActiveLayerIndex();
            if (n2 < n - 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    @Override
    public void activeCompositionHasChanged(Composition composition) {
        this.checkIndex(composition);
    }

    @Override
    public void activeCompLayerCountChanged(Composition composition, int n) {
        this.checkIndex(composition);
    }

    @Override
    public void activeLayerChanged(Layer layer) {
        Composition composition = layer.getComposition();
        this.checkIndex(composition);
    }

    @Override
    public void layerOrderChanged(Composition composition) {
        this.checkIndex(composition);
    }
}

