/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.layers;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.layers.AddNewLayerAction;
import pixelitor.layers.DeleteActiveLayerAction;
import pixelitor.layers.LayerBlendingModePanel;
import pixelitor.layers.LayerDownAction;
import pixelitor.layers.LayerUpAction;
import pixelitor.layers.LayersPanel;
import pixelitor.utils.ImageSwitchListener;

public class LayersContainer
extends JPanel
implements ImageSwitchListener {
    private LayersPanel layersPanel;
    private JScrollPane scrollPane;
    public static final LayersContainer INSTANCE = new LayersContainer();

    private LayersContainer() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)LayerBlendingModePanel.INSTANCE, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = LayersContainer.createButtonFromAction(AddNewLayerAction.INSTANCE);
        JButton jButton2 = LayersContainer.createButtonFromAction(DeleteActiveLayerAction.INSTANCE);
        JButton jButton3 = LayersContainer.createButtonFromAction(LayerUpAction.INSTANCE);
        JButton jButton4 = LayersContainer.createButtonFromAction(LayerDownAction.INSTANCE);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        this.add((Component)jPanel, "South");
        AppLogic.addImageChangeListener(this);
        this.setBorder(BorderFactory.createTitledBorder("Layers"));
    }

    private static JButton createButtonFromAction(Action action) {
        JButton jButton = new JButton(action);
        jButton.setHideActionText(true);
        jButton.setToolTipText((String)action.getValue("Name"));
        return jButton;
    }

    private void setLayersPanel(LayersPanel layersPanel) {
        if (this.layersPanel != null) {
            this.scrollPane.remove(this.layersPanel);
        }
        this.layersPanel = layersPanel;
        this.scrollPane.setViewportView(layersPanel);
    }

    @Override
    public void noOpenImageAnymore() {
        this.scrollPane.setViewportView(null);
    }

    @Override
    public void newImageOpened() {
    }

    @Override
    public void activeCompositionHasChanged(Composition composition) {
    }

    public static boolean areLayersShown() {
        return INSTANCE.getParent() != null;
    }

    public static void showLayersPanel(LayersPanel layersPanel) {
        INSTANCE.setLayersPanel(layersPanel);
    }
}

