/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.menus;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import pixelitor.ExceptionHandler;
import pixelitor.menus.CopyType;
import pixelitor.menus.ImageTransferable;

public class CopyAction
extends AbstractAction {
    private CopyType type;

    public CopyAction(CopyType copyType) {
        super(copyType.toString());
        this.type = copyType;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            BufferedImage bufferedImage = this.type.getCopySource();
            ImageTransferable imageTransferable = new ImageTransferable(bufferedImage);
            clipboard.setContents(imageTransferable, null);
        }
        catch (Exception exception) {
            ExceptionHandler.showExceptionDialog(exception);
        }
    }
}

