/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.menus;

import javax.swing.JComponent;
import pixelitor.PixelitorWindow;
import pixelitor.layers.LayersContainer;
import pixelitor.menus.ShowHideAction;

public class ShowHideAllAction
extends ShowHideAction {
    public static final ShowHideAllAction INSTANCE = new ShowHideAllAction();
    private boolean histogramsWereShown = false;
    private boolean layersWereShown = false;
    private boolean statusBarWasShown = false;
    private boolean toolsWereShown = false;
    private boolean allHidden = false;

    private ShowHideAllAction() {
        super("Show Hidden", "Hide All");
    }

    @Override
    public boolean getVisibilityAtStartUp() {
        return !this.allHidden;
    }

    @Override
    public boolean getCurrentVisibility() {
        return !this.allHidden;
    }

    @Override
    public void setVisibilityAction(boolean bl) {
        PixelitorWindow pixelitorWindow = PixelitorWindow.getInstance();
        if (!bl) {
            this.histogramsWereShown = pixelitorWindow.areHistogramsShown();
            this.layersWereShown = LayersContainer.areLayersShown();
            this.statusBarWasShown = pixelitorWindow.isStatusBarShown();
            this.toolsWereShown = pixelitorWindow.areToolsShown();
        }
        if (this.histogramsWereShown) {
            pixelitorWindow.setHistogramsVisibility(bl, false);
        }
        if (this.layersWereShown) {
            pixelitorWindow.setLayersVisibility(bl, false);
        }
        if (this.statusBarWasShown) {
            pixelitorWindow.setStatusBarVisibility(bl, false);
        }
        if (this.toolsWereShown) {
            pixelitorWindow.setToolsVisibility(bl, false);
        }
        ((JComponent)pixelitorWindow.getContentPane()).revalidate();
        this.allHidden = !bl;
    }
}

