/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.selection;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import pixelitor.tools.UserDrag;

public enum SelectionType {
    RECTANGLE{

        @Override
        public Shape updateShape(UserDrag userDrag, Shape shape) {
            Rectangle rectangle = userDrag.createPositiveRectangle();
            return rectangle;
        }

        public String toString() {
            return "Rectangle";
        }
    }
    ,
    ELLIPSE{

        @Override
        public Shape updateShape(UserDrag userDrag, Shape shape) {
            Rectangle rectangle = userDrag.createPositiveRectangle();
            return new Ellipse2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public String toString() {
            return "Ellipse";
        }
    }
    ,
    LASSO{

        @Override
        public Shape updateShape(UserDrag userDrag, Shape shape) {
            boolean bl = shape == null ? true : !(shape instanceof GeneralPath);
            if (bl) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(userDrag.getStartX(), userDrag.getStartY());
                generalPath.lineTo(userDrag.getEndX(), userDrag.getEndY());
                return generalPath;
            }
            GeneralPath generalPath = (GeneralPath)shape;
            generalPath.lineTo(userDrag.getEndX(), userDrag.getEndY());
            return generalPath;
        }

        public String toString() {
            return "Freehand";
        }
    };


    public abstract Shape updateShape(UserDrag var1, Shape var2);
}

