/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import pixelitor.Composition;
import pixelitor.ImageComponent;
import pixelitor.layers.ImageLayer;
import pixelitor.layers.TmpDrawingLayer;
import pixelitor.tools.GradientColorType;
import pixelitor.tools.GradientType;
import pixelitor.tools.Tool;
import pixelitor.tools.UserDrag;
import pixelitor.utils.BlendingModePanel;

public class GradientTool
extends Tool {
    private boolean thereWasDragging = false;
    private static final String NO_CYCLE_AS_STRING = "No Cycle";
    private static final String REFLECT_AS_STRING = "Reflect";
    private static final String REPEAT_AS_STRING = "Repeat";
    private JComboBox colorTypeSelector;
    private JComboBox typeSelector;
    private JComboBox cycleMethodSelector;
    private JCheckBox invertCheckBox;
    private BlendingModePanel blendingModePanel;

    GradientTool() {
        super('g', "Gradient", "gradient_tool_icon.png", "click and drag to draw a gradient", Cursor.getPredefinedCursor(0), true, true, true);
    }

    @Override
    public void initSettingsPanel() {
        this.toolSettingsPanel.add(new JLabel("Type: "));
        this.typeSelector = new JComboBox<GradientType>(GradientType.values());
        this.toolSettingsPanel.add(this.typeSelector);
        this.toolSettingsPanel.add(new JLabel("Cycling: "));
        this.cycleMethodSelector = new JComboBox<String>(new String[]{NO_CYCLE_AS_STRING, REFLECT_AS_STRING, REPEAT_AS_STRING});
        this.toolSettingsPanel.add(this.cycleMethodSelector);
        this.toolSettingsPanel.addSeparator();
        this.toolSettingsPanel.add(new JLabel("Color: "));
        this.colorTypeSelector = new JComboBox<GradientColorType>(GradientColorType.values());
        this.toolSettingsPanel.add(this.colorTypeSelector);
        this.toolSettingsPanel.add(new JLabel("Invert: "));
        this.invertCheckBox = new JCheckBox();
        this.toolSettingsPanel.add(this.invertCheckBox);
        this.toolSettingsPanel.addSeparator();
        this.blendingModePanel = new BlendingModePanel(true);
        this.toolSettingsPanel.add(this.blendingModePanel);
    }

    @Override
    public void toolMousePressed(MouseEvent mouseEvent, ImageComponent imageComponent) {
    }

    @Override
    public void toolMouseDragged(MouseEvent mouseEvent, ImageComponent imageComponent) {
        this.thereWasDragging = true;
        imageComponent.repaint();
    }

    @Override
    public void toolMouseReleased(MouseEvent mouseEvent, ImageComponent imageComponent) {
        if (this.thereWasDragging) {
            Composition composition = imageComponent.getComp();
            this.saveImageForUndo(composition);
            GradientTool.drawGradient((ImageLayer)composition.getActiveLayer(), (GradientType)((Object)this.typeSelector.getSelectedItem()), (GradientColorType)((Object)this.colorTypeSelector.getSelectedItem()), GradientTool.getCycleMethodFromString((String)this.cycleMethodSelector.getSelectedItem()), this.blendingModePanel.getComposite(), this.userDrag, this.invertCheckBox.isSelected());
            this.thereWasDragging = false;
            composition.imageChanged(true, true);
        }
    }

    @Override
    public boolean mouseClicked(MouseEvent mouseEvent, ImageComponent imageComponent) {
        if (super.mouseClicked(mouseEvent, imageComponent)) {
            return true;
        }
        this.thereWasDragging = false;
        return false;
    }

    public static void drawGradient(ImageLayer imageLayer, GradientType gradientType, GradientColorType gradientColorType, MultipleGradientPaint.CycleMethod cycleMethod, Composite composite, UserDrag userDrag, boolean bl) {
        if (userDrag.isClick()) {
            return;
        }
        TmpDrawingLayer tmpDrawingLayer = imageLayer.createTmpDrawingLayer(composite, true);
        Graphics2D graphics2D = tmpDrawingLayer.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gradientColorType.setInvert(bl);
        Color[] colorArray = new Color[]{gradientColorType.getStartColor(), gradientColorType.getEndColor()};
        Paint paint = gradientType.getGradient(userDrag, colorArray, cycleMethod);
        graphics2D.setPaint(paint);
        int n = tmpDrawingLayer.getWidth();
        int n2 = tmpDrawingLayer.getHeight();
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        imageLayer.mergeTmpDrawingImageDown();
    }

    @Override
    public void paintOverImage(Graphics2D graphics2D) {
        if (this.thereWasDragging) {
            graphics2D.setXORMode(Color.BLACK);
            this.userDrag.drawLine(graphics2D);
        }
    }

    private static MultipleGradientPaint.CycleMethod getCycleMethodFromString(String string) {
        if (string.equals(NO_CYCLE_AS_STRING)) {
            return MultipleGradientPaint.CycleMethod.NO_CYCLE;
        }
        if (string.equals(REFLECT_AS_STRING)) {
            return MultipleGradientPaint.CycleMethod.REFLECT;
        }
        if (string.equals(REPEAT_AS_STRING)) {
            return MultipleGradientPaint.CycleMethod.REPEAT;
        }
        throw new IllegalStateException("should not get here");
    }
}

