/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import pixelitor.tools.UserDrag;
import pixelitor.tools.gradientpaints.AngleGradientPaint;
import pixelitor.tools.gradientpaints.DiamondGradientPaint;
import pixelitor.tools.gradientpaints.SpiralGradientPaint;
import pixelitor.utils.ImageUtils;

public enum GradientType {
    LINEAR{

        public String toString() {
            return "Linear";
        }

        @Override
        public Paint getGradient(UserDrag userDrag, Color[] colorArray, MultipleGradientPaint.CycleMethod cycleMethod) {
            Point2D.Float float_ = userDrag.getStartPoint();
            Point2D.Float float_2 = userDrag.getEndPoint();
            return new LinearGradientPaint(float_, float_2, ImageUtils.FRACTIONS_2_COLOR_UNIFORM, colorArray, cycleMethod, colorSpaceType, gradientTransform);
        }
    }
    ,
    RADIAL{

        public String toString() {
            return "Radial";
        }

        @Override
        public Paint getGradient(UserDrag userDrag, Color[] colorArray, MultipleGradientPaint.CycleMethod cycleMethod) {
            float f = userDrag.getDistance();
            Point2D.Float float_ = userDrag.getStartPoint();
            return new RadialGradientPaint(float_, f, float_, ImageUtils.FRACTIONS_2_COLOR_UNIFORM, colorArray, cycleMethod, colorSpaceType, gradientTransform);
        }
    }
    ,
    ANGLE{

        public String toString() {
            return "Angle";
        }

        @Override
        public Paint getGradient(UserDrag userDrag, Color[] colorArray, MultipleGradientPaint.CycleMethod cycleMethod) {
            return new AngleGradientPaint(userDrag, colorArray[0], colorArray[1], cycleMethod);
        }
    }
    ,
    SPIRAL_CW{

        public String toString() {
            return "CW Spiral";
        }

        @Override
        public Paint getGradient(UserDrag userDrag, Color[] colorArray, MultipleGradientPaint.CycleMethod cycleMethod) {
            return new SpiralGradientPaint(true, userDrag, colorArray[0], colorArray[1], cycleMethod);
        }
    }
    ,
    SPIRAL_CCW{

        public String toString() {
            return "CCW Spiral";
        }

        @Override
        public Paint getGradient(UserDrag userDrag, Color[] colorArray, MultipleGradientPaint.CycleMethod cycleMethod) {
            return new SpiralGradientPaint(false, userDrag, colorArray[0], colorArray[1], cycleMethod);
        }
    }
    ,
    DIAMOND{

        public String toString() {
            return "Diamond";
        }

        @Override
        public Paint getGradient(UserDrag userDrag, Color[] colorArray, MultipleGradientPaint.CycleMethod cycleMethod) {
            return new DiamondGradientPaint(userDrag, colorArray[0], colorArray[1], cycleMethod);
        }
    };

    private static final AffineTransform gradientTransform;
    private static final MultipleGradientPaint.ColorSpaceType colorSpaceType;

    public abstract Paint getGradient(UserDrag var1, Color[] var2, MultipleGradientPaint.CycleMethod var3);

    static {
        gradientTransform = new AffineTransform();
        colorSpaceType = MultipleGradientPaint.ColorSpaceType.SRGB;
    }
}

