/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import pixelitor.Composition;
import pixelitor.ImageComponent;
import pixelitor.tools.Tool;

public class MoveTool
extends Tool {
    public MoveTool() {
        super('v', "Move", "move_tool_icon.gif", "drag to move the active layer, Alt-drag to move a duplicate of the active layer", Cursor.getPredefinedCursor(13), false, true, true);
    }

    @Override
    void initSettingsPanel() {
    }

    @Override
    public void toolMousePressed(MouseEvent mouseEvent, ImageComponent imageComponent) {
        imageComponent.getComp().startTranslation(mouseEvent.isAltDown());
    }

    @Override
    public void toolMouseDragged(MouseEvent mouseEvent, ImageComponent imageComponent) {
        Composition composition = imageComponent.getComp();
        int n = this.userDrag.getHorizontalDifference();
        int n2 = this.userDrag.getVerticalDifference();
        composition.moveActiveContentRelative(n, n2, true);
    }

    @Override
    public void toolMouseReleased(MouseEvent mouseEvent, ImageComponent imageComponent) {
        imageComponent.getComp().endTranslation();
    }

    public static void move(Composition composition, int n, int n2) {
        composition.startTranslation(false);
        composition.moveActiveContentRelative(n, n2, false);
        composition.imageChanged(true, true);
        composition.endTranslation();
    }
}

