/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import org.jdesktop.swingx.geom.Star2D;
import pixelitor.tools.UserDrag;
import pixelitor.tools.shapes.Bat;
import pixelitor.tools.shapes.Cat;
import pixelitor.tools.shapes.Heart;
import pixelitor.tools.shapes.Kiwi;
import pixelitor.tools.shapes.Rabbit;
import pixelitor.utils.Utils;

public enum ShapeType {
    RECTANGLE(true){

        @Override
        public Shape getShape(UserDrag userDrag) {
            this.updateCoordinatesPositive(userDrag);
            return new Rectangle(this.x, this.y, this.width, this.height);
        }

        public String toString() {
            return "Rectangle";
        }
    }
    ,
    ELLIPSE(true){

        @Override
        public Shape getShape(UserDrag userDrag) {
            this.updateCoordinatesPositive(userDrag);
            return new Ellipse2D.Float(this.x, this.y, this.width, this.height);
        }

        public String toString() {
            return "Ellipse";
        }
    }
    ,
    DIAMOND(true){

        @Override
        public Shape getShape(UserDrag userDrag) {
            this.updateCoordinates(userDrag);
            Path2D.Float float_ = new Path2D.Float();
            int n = this.x + this.width / 2;
            int n2 = this.y + this.height / 2;
            float_.moveTo(n, this.y);
            float_.lineTo(this.x + this.width, n2);
            float_.lineTo(n, this.y + this.height);
            float_.lineTo(this.x, n2);
            float_.closePath();
            return float_;
        }

        public String toString() {
            return "Diamond";
        }
    }
    ,
    LINE(false){

        @Override
        public Shape getShape(UserDrag userDrag) {
            return userDrag.asLine();
        }

        public String toString() {
            return "Line";
        }
    }
    ,
    HEART(true){

        @Override
        public Shape getShape(UserDrag userDrag) {
            this.updateCoordinates(userDrag);
            return new Heart(this.x, this.y, this.width, this.height);
        }

        public String toString() {
            return "Heart";
        }
    }
    ,
    STAR(true){

        @Override
        public Shape getShape(UserDrag userDrag) {
            double d;
            double d2;
            this.updateCoordinates(userDrag);
            double d3 = (double)this.width / 2.0;
            double d4 = (double)this.height / 2.0;
            double d5 = (double)this.x + d3;
            double d6 = (double)this.y + d4;
            if (this.width > this.height) {
                d2 = d4;
                d = d3;
            } else if (this.height > this.width) {
                d2 = d3;
                d = d4;
            } else {
                d2 = d3;
                d = d2 + 0.01;
            }
            return new Star2D(d5, d6, d2, d, 7);
        }

        public String toString() {
            return "Star";
        }
    }
    ,
    ARROW(true){
        GeneralPath unitArrow = null;

        @Override
        public Shape getShape(UserDrag userDrag) {
            float f;
            if (this.unitArrow == null) {
                f = 0.3f;
                float f2 = 0.7f;
                float f3 = 0.6f;
                float f4 = f / 2.0f;
                float f5 = f2 / 2.0f;
                this.unitArrow = new GeneralPath();
                this.unitArrow.moveTo(0.0f, -f4);
                this.unitArrow.lineTo(0.0f, f4);
                this.unitArrow.lineTo(f3, f4);
                this.unitArrow.lineTo(f3, f5);
                this.unitArrow.lineTo(1.0f, 0.0f);
                this.unitArrow.lineTo(f3, -f5);
                this.unitArrow.lineTo(f3, -f4);
                this.unitArrow.closePath();
            }
            this.updateCoordinates(userDrag);
            f = userDrag.getDistance();
            if (userDrag.isStartFromCenter()) {
                f *= 2.0f;
            }
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.x, this.y);
            affineTransform.scale(f, f);
            double d = userDrag.getDrawAngle();
            double d2 = Utils.transformAtanAngleToIntuitive(d);
            affineTransform.rotate(d2 += 1.5707963267948966);
            return affineTransform.createTransformedShape(this.unitArrow);
        }

        public String toString() {
            return "Arrow";
        }
    }
    ,
    CAT(true){

        @Override
        public Shape getShape(UserDrag userDrag) {
            this.updateCoordinates(userDrag);
            return new Cat(this.x, this.y, this.width, this.height);
        }

        public String toString() {
            return "Cat";
        }
    }
    ,
    KIWI(true){

        @Override
        public Shape getShape(UserDrag userDrag) {
            this.updateCoordinates(userDrag);
            return new Kiwi(this.x, this.y, this.width, this.height);
        }

        public String toString() {
            return "Kiwi";
        }
    }
    ,
    BAT(true){

        @Override
        public Shape getShape(UserDrag userDrag) {
            this.updateCoordinates(userDrag);
            return new Bat(this.x, this.y, this.width, this.height);
        }

        public String toString() {
            return "Bat";
        }
    }
    ,
    RABBIT(true){

        @Override
        public Shape getShape(UserDrag userDrag) {
            this.updateCoordinates(userDrag);
            return new Rabbit(this.x, this.y, this.width, this.height);
        }

        public String toString() {
            return "Rabbit";
        }
    };

    private final boolean closed;
    protected int x;
    protected int y;
    protected int width;
    protected int height;

    protected void updateCoordinatesPositive(UserDrag userDrag) {
        Rectangle rectangle = userDrag.createPositiveRectangle();
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    protected void updateCoordinates(UserDrag userDrag) {
        Rectangle rectangle = userDrag.createPossiblyEmptyRectangle();
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    private ShapeType(boolean bl) {
        this.closed = bl;
    }

    public abstract Shape getShape(UserDrag var1);

    public boolean isClosed() {
        return this.closed;
    }
}

