/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import pixelitor.ImageComponent;

public class UserDrag {
    private int startX;
    private int startY;
    private int endX;
    private int endY;
    private boolean startFromCenter;
    private int oldEndX;
    private int oldEndY;
    private boolean constrainPoints = false;

    public UserDrag() {
    }

    public UserDrag(int n, int n2, int n3, int n4) {
        this.startX = n;
        this.startY = n2;
        this.endX = n3;
        this.endY = n4;
    }

    public void setStartFromMouseEvent(MouseEvent mouseEvent, ImageComponent imageComponent) {
        double d = imageComponent.getViewScale();
        this.startX = (int)((double)mouseEvent.getX() / d);
        this.startY = (int)((double)mouseEvent.getY() / d);
    }

    public void setEndFromMouseEvent(MouseEvent mouseEvent, ImageComponent imageComponent) {
        double d = imageComponent.getViewScale();
        this.endX = (int)((double)mouseEvent.getX() / d);
        this.endY = (int)((double)mouseEvent.getY() / d);
        if (this.constrainPoints) {
            int n;
            int n2 = Math.abs(this.endX - this.startX);
            if (n2 > (n = Math.abs(this.endY - this.startY))) {
                this.endY = this.startY;
            } else {
                this.endX = this.startX;
            }
        }
    }

    public void setConstrainPoints(boolean bl) {
        this.constrainPoints = bl;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartY() {
        return this.startY;
    }

    public int getStartXFromCenter() {
        if (this.startFromCenter) {
            return this.startX - (this.endX - this.startX);
        }
        return this.startX;
    }

    public int getStartYFromCenter() {
        if (this.startFromCenter) {
            return this.startY - (this.endY - this.startY);
        }
        return this.startY;
    }

    public int getEndX() {
        return this.endX;
    }

    public int getEndY() {
        return this.endY;
    }

    public Point2D.Float getStartPoint() {
        return new Point2D.Float(this.startX, this.startY);
    }

    public Point2D.Float getEndPoint() {
        return new Point2D.Float(this.endX, this.endY);
    }

    public float getDistance() {
        int n = this.startX - this.endX;
        int n2 = this.startY - this.endY;
        return (float)Math.sqrt(n * n + n2 * n2);
    }

    public double getStartDistanceFrom(int n, int n2) {
        int n3 = this.startX - n;
        int n4 = this.startY - n2;
        return Math.sqrt(n3 * n3 + n4 * n4);
    }

    public double getDrawAngle() {
        return Math.atan2(this.endX - this.startX, this.endY - this.startY);
    }

    public double getAngleFromStartTo(int n, int n2) {
        return Math.atan2(n - this.startX, n2 - this.startY);
    }

    public void drawLine(Graphics graphics) {
        graphics.drawLine(this.startX, this.startY, this.endX, this.endY);
    }

    public Line2D asLine() {
        return new Line2D.Float(this.startX, this.startY, this.endX, this.endY);
    }

    public void saveEndValues() {
        this.oldEndX = this.endX;
        this.oldEndY = this.endY;
    }

    public void adjustStartForSpaceDownMove() {
        int n = this.endX - this.oldEndX;
        int n2 = this.endY - this.oldEndY;
        this.startX += n;
        this.startY += n2;
    }

    public int getHorizontalDifference() {
        return this.endX - this.startX;
    }

    public int getVerticalDifference() {
        return this.endY - this.startY;
    }

    public Rectangle createPossiblyEmptyRectangle() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.startFromCenter) {
            int n5 = this.endX - this.startX;
            int n6 = this.endY - this.startY;
            n4 = this.startX - n5;
            n3 = this.startY - n6;
            n2 = 2 * n5;
            n = 2 * n6;
        } else {
            n4 = this.startX;
            n3 = this.startY;
            n2 = this.endX - this.startX;
            n = this.endY - this.startY;
        }
        return new Rectangle(n4, n3, n2, n);
    }

    public Rectangle createPositiveRectangle() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.startFromCenter) {
            int n5;
            int n6;
            if (this.endX > this.startX) {
                n6 = this.endX - this.startX;
                n4 = this.startX - n6;
            } else {
                n6 = this.startX - this.endX;
                n4 = this.endX;
            }
            if (this.endY > this.startY) {
                n5 = this.endY - this.startY;
                n3 = this.startY - n5;
            } else {
                n5 = this.startY - this.endY;
                n3 = this.endY;
            }
            n2 = 2 * n6;
            n = 2 * n5;
        } else {
            int n7;
            int n8;
            if (this.endX > this.startX) {
                n4 = this.startX;
                n8 = this.endX;
            } else {
                n4 = this.endX;
                n8 = this.startX;
            }
            if (this.endY > this.startY) {
                n3 = this.startY;
                n7 = this.endY;
            } else {
                n3 = this.endY;
                n7 = this.startY;
            }
            n2 = n8 - n4;
            n = n7 - n3;
        }
        return new Rectangle(n4, n3, n2, n);
    }

    public Point2D getCenterPoint() {
        float f = (float)(this.startX + this.endX) / 2.0f;
        float f2 = (float)(this.startY + this.endY) / 2.0f;
        return new Point2D.Float(f, f2);
    }

    public void setStartFromCenter(boolean bl) {
        this.startFromCenter = bl;
    }

    public boolean isClick() {
        return this.startX == this.endX && this.startY == this.endY;
    }

    public boolean isStartFromCenter() {
        return this.startFromCenter;
    }
}

