/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools.toolhandlers;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import pixelitor.AppLogic;
import pixelitor.GlobalKeyboardWatch;
import pixelitor.ImageComponent;
import pixelitor.tools.Tools;
import pixelitor.tools.toolhandlers.ToolEventHandler;

public class HandToolEventHandler
extends ToolEventHandler {
    private boolean handToolForwarding = false;
    private boolean normalToolUsage = false;
    private boolean spaceDown = false;
    private Cursor cursor;

    public HandToolEventHandler(Cursor cursor) {
        this.cursor = cursor;
    }

    @Override
    boolean mousePressed(MouseEvent mouseEvent, ImageComponent imageComponent) {
        if (GlobalKeyboardWatch.isSpaceDown()) {
            Tools.HAND.mousePressed(mouseEvent, imageComponent);
            this.handToolForwarding = true;
            return true;
        }
        this.normalToolUsage = true;
        this.handToolForwarding = false;
        return false;
    }

    @Override
    boolean mouseDragged(MouseEvent mouseEvent, ImageComponent imageComponent) {
        if (this.handToolForwarding) {
            Tools.HAND.mouseDragged(mouseEvent, imageComponent);
            return true;
        }
        this.normalToolUsage = true;
        return false;
    }

    @Override
    boolean mouseReleased(MouseEvent mouseEvent, ImageComponent imageComponent) {
        this.normalToolUsage = false;
        if (this.handToolForwarding) {
            Tools.HAND.toolMouseReleased(mouseEvent, imageComponent);
            this.handToolForwarding = false;
            AppLogic.setToolCursor(this.cursor);
            return true;
        }
        return false;
    }

    public void spacePressed() {
        if (!this.spaceDown && !this.normalToolUsage) {
            AppLogic.setToolCursor(Tools.HAND.getCursor());
        }
        this.spaceDown = true;
    }

    public void spaceReleased() {
        this.spaceDown = false;
        if (!this.handToolForwarding) {
            AppLogic.setToolCursor(this.cursor);
        }
    }
}

