/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pixelitor.utils.IconUtils;
import pixelitor.utils.IntTextField;

public class DropDownSlider
extends JComponent
implements MouseListener,
ChangeListener,
ActionListener {
    private static final Icon downIconEnabled = IconUtils.loadIcon("dropdown_enabled.gif");
    private static final Icon downIconDisabled = IconUtils.loadIcon("dropdown_disabled.gif");
    private IntTextField textField;
    private JButton dropDownButton;
    private JPopupMenu popupMenu;
    private boolean dropDownEnabled = true;
    private JSlider slider;

    public DropDownSlider(int n, int n2, int n3, boolean bl) {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.textField = new IntTextField(String.valueOf(n), n2, n3, bl, 4);
        this.add(this.textField);
        this.dropDownButton = new JButton(downIconEnabled);
        this.dropDownButton.setDisabledIcon(downIconDisabled);
        this.dropDownButton.putClientProperty("JComponent.sizeVariant", "mini");
        this.dropDownButton.setRequestFocusEnabled(false);
        this.dropDownButton.setInheritsPopupMenu(true);
        this.dropDownButton.setBorderPainted(false);
        this.dropDownButton.setFocusPainted(false);
        this.dropDownButton.addMouseListener(this);
        this.dropDownButton.setIconTextGap(0);
        this.dropDownButton.setBorder(null);
        this.dropDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.textField.add(this.dropDownButton);
        Dimension dimension = this.textField.getPreferredSize();
        int n4 = 17;
        int n5 = 22;
        int n6 = dimension.width - n4;
        int n7 = (dimension.height - n5) / 2;
        this.dropDownButton.setBounds(n6, n7, n4, n5);
        this.slider = new JSlider(0, n2, n3, n);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setLayout(new FlowLayout(1, 5, 1));
        this.popupMenu.add(this.slider);
        this.slider.addChangeListener(this);
        this.textField.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2;
        Object object = actionEvent.getSource();
        if (object == this.textField && (n2 = this.textField.getIntValue()) != (n = this.slider.getValue())) {
            this.slider.setValue(n2);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.slider) {
            int n = this.slider.getValue();
            this.textField.setText(String.valueOf(n));
            if (!this.slider.getValueIsAdjusting()) {
                this.textField.fireActionPerformed();
            }
        }
    }

    public int getValue() {
        return this.textField.getIntValue();
    }

    public void setValue(int n) {
        this.textField.setText(String.valueOf(n));
        this.slider.setValue(n);
    }

    public void addActionListener(ActionListener actionListener) {
        this.textField.addActionListener(actionListener);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.popupMenu.isShowing() && this.dropDownEnabled) {
            this.popupMenu.setVisible(false);
        } else if (this.dropDownEnabled) {
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.popupMenu.getPreferredSize();
            this.popupMenu.show(this, dimension.width - dimension2.width, dimension.height);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.dropDownButton.setBorderPainted(true);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.dropDownButton.setBorderPainted(false);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.textField.setEnabled(bl);
        this.dropDownButton.setEnabled(bl);
        this.dropDownEnabled = bl;
    }
}

