/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import pixelitor.ExceptionHandler;
import pixelitor.io.FileExtensionUtils;

public class ImagePreviewPanel
extends JPanel
implements PropertyChangeListener {
    private static final int SIZE = 200;
    private static final int EMPTY_SPACE_AT_LEFT = 5;
    private Image smallImage;
    private Color backgroundColor;
    private int newImgWidth;
    private int newImgHeight;
    private int imgWidth;
    private int imgHeight;
    private static final int MSG_STRING_X = 20;
    private static final int MSG_STRING_Y = 31;

    public ImagePreviewPanel() {
        this.setPreferredSize(new Dimension(200, 200));
        this.backgroundColor = this.getBackground();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        File file;
        String string = propertyChangeEvent.getPropertyName();
        if ("directoryChanged".equals(string)) {
            file = null;
        } else if ("SelectedFileChangedProperty".equals(string)) {
            file = (File)propertyChangeEvent.getNewValue();
        } else {
            return;
        }
        if (file == null) {
            this.smallImage = null;
            this.repaint();
            return;
        }
        String string2 = file.getAbsolutePath();
        if (FileExtensionUtils.isSupportedExtension(string2, FileExtensionUtils.SUPPORTED_INPUT_FORMATS)) {
            Image image = null;
            if (string2.toLowerCase().endsWith(".bmp")) {
                try {
                    image = ImageIO.read(file);
                }
                catch (IOException iOException) {
                    ExceptionHandler.showExceptionDialog(iOException);
                }
            } else {
                ImageIcon imageIcon = new ImageIcon(string2);
                image = imageIcon.getImage();
            }
            this.smallImage = this.scaleImage(image);
            this.repaint();
        }
    }

    private Image scaleImage(Image image) {
        if (image == null) {
            return null;
        }
        this.imgWidth = image.getWidth(null);
        this.imgHeight = image.getHeight(null);
        int n = this.getWidth() - 5;
        int n2 = this.getHeight();
        double d = (double)n2 / (double)this.imgHeight;
        double d2 = (double)n / (double)this.imgWidth;
        double d3 = Math.min(d, d2);
        this.newImgWidth = (int)(d3 * (double)this.imgWidth);
        this.newImgHeight = (int)(d3 * (double)this.imgHeight);
        return image.getScaledInstance(this.newImgWidth, this.newImgHeight, 2);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.backgroundColor);
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.fillRect(0, 0, n, n2);
        if (this.smallImage != null) {
            int n3 = (n - this.newImgWidth) / 2 + 5;
            int n4 = (n2 - this.newImgHeight) / 2;
            graphics.drawImage(this.smallImage, n3, n4, this);
            boolean bl = n4 < 21;
            String string = "Size: " + this.imgWidth + " x " + this.imgHeight + " pixels";
            if (this.imgWidth == -1 || this.imgHeight == -1) {
                string = "Unrecognized!";
                bl = false;
            }
            graphics.setColor(Color.black);
            graphics.drawString(string, 20, 31);
            if (bl) {
                graphics.setColor(Color.white);
                graphics.drawString(string, 19, 30);
            }
        }
    }
}

