/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class IntTextField
extends JTextField
implements KeyListener {
    private int minValue;
    private int maxValue;
    private boolean limitRange;

    public IntTextField(String string, int n, int n2, boolean bl, int n3) {
        super(string, n3);
        this.minValue = n;
        this.maxValue = n2;
        this.limitRange = bl;
        this.init();
    }

    public IntTextField(String string) {
        super(string);
        this.init();
    }

    public IntTextField(int n) {
        super(n);
        this.init();
    }

    private void init() {
        this.addKeyListener(this);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!Character.isDigit(c) && c != '\b' && c != '\n' && c != '\u007f') {
            if (c != '\u001a') {
                this.getToolkit().beep();
            }
            keyEvent.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public int getIntValue() {
        String string = this.getText();
        int n = Integer.parseInt(string);
        if (this.limitRange) {
            if (n > this.maxValue) {
                n = this.maxValue;
                this.setText(String.valueOf(n));
            } else if (n < this.minValue) {
                n = this.minValue;
                this.setText(String.valueOf(n));
            }
        }
        return n;
    }

    public void setRange(int n, int n2) {
        this.minValue = n;
        this.maxValue = n2;
        this.limitRange = true;
    }

    @Override
    public void fireActionPerformed() {
        super.fireActionPerformed();
    }
}

