/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URI;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import pixelitor.Build;
import pixelitor.ExceptionHandler;
import pixelitor.PixelitorWindow;
import pixelitor.utils.BlendingModePanel;
import pixelitor.utils.NotANumberException;
import pixelitor.utils.SliderSpinner;

public final class Utils {
    private static final int BYTES_IN_1_MEGABYTE = 0x100000;
    private static final int BYTES_IN_1_KILOBYTE = 1024;
    private static final Cursor BUSY_CURSOR = Cursor.getPredefinedCursor(3);
    private static final Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();
    private static final int WAIT_CURSOR_DELAY = 300;
    public static final Color TRANSPARENT_COLOR = new Color(0, true);

    private Utils() {
    }

    public static void executeWithBusyCursor(Runnable runnable, boolean bl) {
        Utils.executeWithBusyCursor(PixelitorWindow.getInstance(), runnable, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeWithBusyCursor(final Component component, Runnable runnable, boolean bl) {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                component.setCursor(BUSY_CURSOR);
            }
        };
        Timer timer = new Timer();
        try {
            timer.schedule(timerTask, 300L);
            if (bl) {
                Thread thread = new Thread(runnable);
                thread.setPriority(5);
                thread.start();
            } else {
                runnable.run();
            }
        }
        finally {
            timer.cancel();
            component.setCursor(DEFAULT_CURSOR);
        }
    }

    public static void openURI(URI uRI) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uRI);
            }
            catch (IOException iOException) {
                ExceptionHandler.showExceptionDialog(iOException);
            }
        }
    }

    public static String toFileName(String string) {
        return string.replaceAll("[^A-Za-z0-9_]", "_");
    }

    public static void debugThread() {
        Thread thread = Thread.currentThread();
        String string = thread.getName();
        System.out.println("Utils.debugThread name = \"" + string + '\"');
        boolean bl = SwingUtilities.isEventDispatchThread();
        System.out.println("Utils.debugThread eventDispatchThread = " + bl);
    }

    public static void randomizeGUIWidgetsOn(JPanel jPanel) {
        int n = jPanel.getComponentCount();
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            JComponent jComponent;
            Component component = jPanel.getComponent(i);
            if (component instanceof JComboBox) {
                jComponent = (JComboBox)component;
                int n2 = ((JComboBox)jComponent).getItemCount();
                ((JComboBox)jComponent).setSelectedIndex(random.nextInt(n2));
                continue;
            }
            if (component instanceof JCheckBox) {
                jComponent = (JCheckBox)component;
                ((AbstractButton)jComponent).setSelected(random.nextBoolean());
                continue;
            }
            if (component instanceof SliderSpinner) {
                jComponent = (SliderSpinner)component;
                ((SliderSpinner)jComponent).getModel().randomize();
                continue;
            }
            if (!(component instanceof BlendingModePanel)) continue;
            jComponent = (BlendingModePanel)component;
            ((BlendingModePanel)jComponent).randomize();
        }
    }

    public static String float2String(float f) {
        if (f == 0.0f) {
            return "";
        }
        return String.format("%.3f", Float.valueOf(f));
    }

    public static float string2float(String string) throws NotANumberException {
        Number number;
        String string2 = string.trim();
        if (string2.length() == 0) {
            return 0.0f;
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        try {
            number = numberFormat.parse(string2);
        }
        catch (ParseException parseException) {
            NumberFormat numberFormat2 = NumberFormat.getInstance(Locale.ENGLISH);
            try {
                number = numberFormat2.parse(string2);
            }
            catch (ParseException parseException2) {
                throw new NotANumberException(string);
            }
        }
        return number.floatValue();
    }

    public static void throwTestException() {
        if (Build.CURRENT != Build.FINAL) {
            throw new IllegalStateException("Test");
        }
    }

    public static String bytesToString(int n) {
        if (n < 1024) {
            return n + " bytes";
        }
        if (n < 0x100000) {
            float f = (float)n / 1024.0f;
            return String.format("%.2f kilobytes", Float.valueOf(f));
        }
        float f = (float)n / 1048576.0f;
        return String.format("%.2f megabytes", Float.valueOf(f));
    }

    public static int getMaxHeapInMegabytes() {
        long l = Runtime.getRuntime().maxMemory();
        int n = (int)(l / 0x100000L);
        return n;
    }

    public static int getUsedMemoryInMegabytes() {
        long l = Runtime.getRuntime().totalMemory();
        int n = (int)(l / 0x100000L);
        return n;
    }

    public static boolean checkRasterMinimum(BufferedImage bufferedImage) {
        WritableRaster writableRaster;
        if (Build.CURRENT.isRobotTest() && ((writableRaster = bufferedImage.getRaster()).getMinX() != 0 || writableRaster.getMinY() != 0)) {
            throw new IllegalArgumentException("Raster " + writableRaster + " has minX or minY not equal to zero: " + writableRaster.getMinX() + " " + writableRaster.getMinY());
        }
        return true;
    }

    public static void copyStringToClipboard(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            }
        });
    }

    public static ProgressMonitor createProgressMonitor(String string) {
        return new ProgressMonitor(PixelitorWindow.getInstance(), string, "", 0, 100);
    }

    public static double transformAtanAngleToIntuitive(double d) {
        double d2 = d <= 0.0 ? -d : Math.PI * 2 - d;
        return d2;
    }

    public static Point2D calculateOffset(int n, double d) {
        int n2 = (int)((double)n * Math.cos(d));
        int n3 = (int)((double)n * Math.sin(d));
        return new Point(n2, n3);
    }

    public static float fastAtan(float f) {
        if (f <= 1.0f) {
            return (float)((double)f / (1.0 + 0.28 * (double)f * (double)f));
        }
        return Utils.fastAtan(1.0f / f);
    }
}

