/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils.debug;

import java.awt.color.ColorSpace;
import pixelitor.utils.debug.DebugNode;

public class ColorSpaceNode
extends DebugNode {
    public ColorSpaceNode(ColorSpace colorSpace) {
        super("ColorSpace", colorSpace);
        this.addClassChild();
        int n = colorSpace.getNumComponents();
        this.addIntChild("numComponents", n);
        int n2 = colorSpace.getType();
        this.addStringChild("type", ColorSpaceNode.getColorSpaceTypeDescription(n2));
        boolean bl = colorSpace.isCS_sRGB();
        this.addBooleanChild("is_sRGB", bl);
    }

    private static String getColorSpaceTypeDescription(int n) {
        switch (n) {
            case 12: {
                return "TYPE_2CLR";
            }
            case 13: {
                return "TYPE_3CLR";
            }
            case 14: {
                return "TYPE_4CLR";
            }
            case 15: {
                return "TYPE_5CLR";
            }
            case 16: {
                return "TYPE_6CLR";
            }
            case 17: {
                return "TYPE_7CLR";
            }
            case 18: {
                return "TYPE_8CLR";
            }
            case 19: {
                return "TYPE_9CLR";
            }
            case 20: {
                return "TYPE_ACLR";
            }
            case 21: {
                return "TYPE_BCLR";
            }
            case 22: {
                return "TYPE_CCLR";
            }
            case 11: {
                return "TYPE_CMY";
            }
            case 9: {
                return "TYPE_CMYK";
            }
            case 23: {
                return "TYPE_DCLR";
            }
            case 24: {
                return "TYPE_ECLR";
            }
            case 25: {
                return "TYPE_FCLR";
            }
            case 6: {
                return "TYPE_GRAY";
            }
            case 8: {
                return "TYPE_HLS";
            }
            case 7: {
                return "TYPE_HSV";
            }
            case 1: {
                return "TYPE_Lab";
            }
            case 2: {
                return "TYPE_Luv";
            }
            case 5: {
                return "TYPE_RGB";
            }
            case 0: {
                return "TYPE_XYZ";
            }
            case 3: {
                return "TYPE_YCbCr";
            }
            case 4: {
                return "TYPE_Yxy";
            }
        }
        return "UNKNOWN";
    }
}

