/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils.debug;

import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.image.ColorModel;
import pixelitor.utils.Utils;
import pixelitor.utils.debug.ColorModelNode;
import pixelitor.utils.debug.DebugNode;

public class SystemNode
extends DebugNode {
    public SystemNode(GraphicsDevice graphicsDevice) {
        super("System", graphicsDevice);
        this.addStringChild("Java version", System.getProperty("java.version"));
        this.addStringChild("Java vendor", System.getProperty("java.vendor"));
        this.addStringChild("OS name", System.getProperty("os.name"));
        DisplayMode displayMode = graphicsDevice.getDisplayMode();
        int n = displayMode.getWidth();
        int n2 = displayMode.getHeight();
        int n3 = displayMode.getBitDepth();
        this.addIntChild("display width", n);
        this.addIntChild("display height", n2);
        this.addIntChild("display bit depth", n3);
        this.addStringChild("max memory", Utils.getMaxHeapInMegabytes() + " Mb");
        this.addStringChild("used memory", Utils.getUsedMemoryInMegabytes() + " Mb");
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        ColorModel colorModel = graphicsConfiguration.getColorModel();
        ColorModelNode colorModelNode = new ColorModelNode("Default Color Model", colorModel);
        this.add(colorModelNode);
    }
}

