/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils.test;

import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import pixelitor.AppLogic;
import pixelitor.ChangeReason;
import pixelitor.Composition;
import pixelitor.PixelitorWindow;
import pixelitor.automate.SingleDirChooserPanel;
import pixelitor.filters.Fade;
import pixelitor.filters.Filter;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.comp.CompositionUtils;
import pixelitor.filters.gui.ParametrizedAdjustPanel;
import pixelitor.history.History;
import pixelitor.io.OpenSaveManager;
import pixelitor.io.OutputFormat;
import pixelitor.utils.Utils;
import pixelitor.utils.test.RobotTest;

public class OpTests {
    private OpTests() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTheResultOfEachOp() {
        boolean bl;
        boolean bl2 = bl = !SingleDirChooserPanel.selectOutputDir(true);
        if (bl) {
            return;
        }
        final File file = OpenSaveManager.getLastSaveDir();
        final OutputFormat outputFormat = OutputFormat.getLastOutputFormat();
        ParametrizedAdjustPanel.setResetParams(false);
        final ProgressMonitor progressMonitor = Utils.createProgressMonitor("Saving the Results of Each Operation");
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                if (file != null) {
                    Filter[] filterArray = FilterUtils.getAllFiltersShuffled();
                    progressMonitor.setProgress(0);
                    for (int i = 0; i < filterArray.length; ++i) {
                        Filter filter = filterArray[i];
                        if (filter instanceof Fade) continue;
                        progressMonitor.setProgress((int)((float)i * 100.0f / (float)filterArray.length));
                        if (!filter.isEnabled()) continue;
                        progressMonitor.setNote("Running " + filter.getMenuName());
                        if (progressMonitor.isCanceled()) break;
                        filter.randomizeSettings();
                        filter.execute(ChangeReason.OP_WITHOUT_DIALOG);
                        Composition composition = AppLogic.getActiveComp();
                        String string = "test_" + Utils.toFileName(filter.getMenuName()) + '.' + outputFormat.toString();
                        File file2 = new File(file, string);
                        outputFormat.saveComposition(composition, file2);
                        if (!History.canUndo()) continue;
                        History.undo();
                    }
                    progressMonitor.close();
                }
                return null;
            }
        };
        try {
            swingWorker.execute();
        }
        finally {
            ParametrizedAdjustPanel.setResetParams(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAllOpsOnCurrentLayer() {
        ParametrizedAdjustPanel.setResetParams(false);
        try {
            ProgressMonitor progressMonitor = new ProgressMonitor(PixelitorWindow.getInstance(), "Run All Operations on Current Layer", "", 0, 100);
            progressMonitor.setProgress(0);
            Filter[] filterArray = FilterUtils.getAllFiltersShuffled();
            int n = filterArray.length;
            for (int i = 0; i < n; ++i) {
                progressMonitor.setProgress((int)((float)i * 100.0f / (float)n));
                Filter filter = filterArray[i];
                String string = "Running " + filter.getMenuName();
                progressMonitor.setNote(string);
                if (progressMonitor.isCanceled()) break;
                filter.randomizeSettings();
                filter.actionPerformed(null);
            }
            progressMonitor.close();
        }
        finally {
            ParametrizedAdjustPanel.setResetParams(true);
        }
    }

    public static void getCompositeImagePerformanceTest() {
        final Composition composition = AppLogic.getActiveComp();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                long l = System.nanoTime();
                int n = 100;
                for (int i = 0; i < n; ++i) {
                    composition.getCompositeImage();
                }
                long l2 = (System.nanoTime() - l) / 1000000L;
                String string = "Executing getCompositeImage() " + n + " times took " + l2 + " ms, average time = " + l2 / (long)n + " ms";
                JOptionPane.showMessageDialog(PixelitorWindow.getInstance(), string, "Test Result", 1);
            }
        };
        Utils.executeWithBusyCursor(runnable, false);
    }

    public static void randomResize() {
        Composition composition = AppLogic.getActiveComp();
        if (composition != null) {
            int n = 1 + RobotTest.rand.nextInt(600);
            int n2 = 1 + RobotTest.rand.nextInt(400);
            CompositionUtils.resize(composition, n, n2, false);
        }
    }
}

