/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.cr2;

import it.tidalwave.imageio.decoder.LosslessJPEGDecoder;
import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.raw.RasterReader;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CR2RasterReader
extends RasterReader {
    private static final int BUFFER_SIZE = 131072;
    private int canonTileWidth;
    private int canonLastTileWidth;

    public void setCanonTileWidth(@Nonnegative int canonTileWidth) {
        this.canonTileWidth = canonTileWidth;
    }

    public void setCanonLastTileWidth(@Nonnegative int canonLastTileWidth) {
        this.canonLastTileWidth = canonLastTileWidth;
    }

    protected boolean isCompressedRaster() {
        return true;
    }

    protected void loadCompressedRaster(@Nonnull RAWImageInputStream iis, @Nonnull WritableRaster raster, @Nonnull RAWImageReaderSupport ir) throws IOException {
        LosslessJPEGDecoder jpegDecoder = new LosslessJPEGDecoder();
        ByteOrder byteOrderSaved = iis.getByteOrder();
        iis.setByteOrder(ByteOrder.BIG_ENDIAN);
        jpegDecoder.reset(iis);
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int pixelStride = 3;
        int scanStride = width * 3;
        iis.selectBitReader(-1, 131072);
        iis.setSkipZeroAfterFF(true);
        int wholeTileCount = this.canonTileWidth != 0 ? (width - this.canonLastTileWidth) / this.canonTileWidth : 0;
        int odd = height % 2;
        for (int y = 0; y < height; ++y) {
            short[] rowBuffer = jpegDecoder.loadRow(iis);
            for (int x = 0; x < width; ++x) {
                int value = rowBuffer[x];
                if (this.linearizationTable != null) {
                    value = this.linearizationTable[value & 0xFFFF];
                }
                int xx = x;
                int yy = y;
                if (this.canonTileWidth != 0) {
                    int scan = y * width + x;
                    int tileIndex = scan / (this.canonTileWidth * height);
                    if (tileIndex < wholeTileCount) {
                        xx = scan % this.canonTileWidth + tileIndex * this.canonTileWidth;
                        yy = scan / this.canonTileWidth % height;
                    } else {
                        xx = (scan -= wholeTileCount * this.canonTileWidth * height) % this.canonLastTileWidth + wholeTileCount * this.canonTileWidth;
                        yy = scan / this.canonLastTileWidth;
                    }
                }
                if (xx >= width || (yy -= odd) < 0 || yy >= height) continue;
                int cfaIndex = yy % 2 * 2 + xx % 2;
                data[yy * scanStride + xx * 3 + this.cfaOffsets[cfaIndex]] = (short)value;
            }
            ir.processImageProgress(100.0f * (float)y / (float)height);
        }
        iis.setByteOrder(byteOrderSaved);
    }
}

