/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.dng;

import it.tidalwave.imageio.decoder.LosslessJPEGDecoder;
import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.tiff.IFDGenerated;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;

public class DNGRasterReader
extends RasterReader {
    private static final int BUFFER_SIZE = 131072;
    private static final Logger logger = Logger.getLogger("it.tidalwave.imageio.dng.DNGRasterReader");

    protected boolean isCompressedRaster() {
        return this.compression == IFDGenerated.Compression.JPEG.intValue();
    }

    protected void loadCompressedRaster(RAWImageInputStream iis, WritableRaster raster, RAWImageReaderSupport ir) throws IOException {
        logger.finest(">>>> tileSize:    %d x %d", this.tileWidth, this.tileHeight);
        logger.finest(">>>> tileCount:   %d x %d", this.tilesAcross, this.tilesDown);
        ByteOrder byteOrderSaved = iis.getByteOrder();
        iis.setByteOrder(ByteOrder.BIG_ENDIAN);
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int pixelStride = 3;
        int scanStride = width * pixelStride;
        int tileIndex = 0;
        LosslessJPEGDecoder jpegDecoder = new LosslessJPEGDecoder();
        iis.selectBitReader(-1, 0);
        iis.setSkipZeroAfterFF(true);
        for (int tileRow = 0; tileRow < this.tilesDown; ++tileRow) {
            for (int tileColumn = 0; tileColumn < this.tilesAcross; ++tileColumn) {
                iis.seek(this.tileOffsets[tileIndex]);
                jpegDecoder.reset(iis);
                for (int tileY = 0; tileY < this.tileHeight; ++tileY) {
                    int x;
                    short[] rowBuffer = jpegDecoder.loadRow(iis);
                    int y = tileRow * this.tileHeight + tileY;
                    if (y >= height) break;
                    for (int tileX = 0; tileX < this.tileWidth && (x = tileColumn * this.tileWidth + tileX) < width; ++tileX) {
                        short value = rowBuffer[tileX];
                        if (this.linearizationTable != null) {
                            value = (short)this.linearizationTable[value & 0xFFFF];
                        }
                        int cfaIndex = y % 2 * 2 + x % 2;
                        data[y * scanStride + x * pixelStride + this.cfaOffsets[cfaIndex]] = value;
                    }
                }
                ir.processImageProgress(100.0f * (float)(++tileIndex) / (float)(this.tilesDown * this.tilesAcross));
            }
        }
        iis.setByteOrder(byteOrderSaved);
    }
}

