/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.io;

import it.tidalwave.imageio.io.BitReader;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.imageio.stream.ImageInputStream;

class SixteenBitsReader
extends BitReader {
    public SixteenBitsReader(ImageInputStream iis, int bufferSize) {
        this.iis = iis;
        this.byteBuffer = new byte[bufferSize];
        this.bytePointer = this.byteBuffer.length;
    }

    public void resync() {
        this.bytePointer = this.byteBuffer.length;
    }

    public int readBits(int bitsToGet) throws IOException {
        if (bitsToGet != 16) {
            throw new IllegalArgumentException("SixteenBitsReader only reads 16 bits");
        }
        if (this.bytePointer >= this.bufferSize) {
            this.bytePointer = 0;
            this.bufferSize = this.iis.read(this.byteBuffer);
        }
        int b1 = this.byteBuffer[this.bytePointer++] & 0xFF;
        int b0 = this.byteBuffer[this.bytePointer++] & 0xFF;
        return b0 << 8 | b1 & 0xFF;
    }

    public void skipBits(int bitsToSkip) {
        if (bitsToSkip % 8 != 0) {
            throw new IllegalArgumentException("SixteenBitsReader.skipBits(): only multiple of 8");
        }
        int bytes = bitsToSkip / 8;
        this.bytePointer += bytes;
    }

    public void setSkipZeroAfterFF(boolean skipZeroAfterFF) {
        throw new UnsupportedOperationException();
    }

    public void setBitOffset(int bitPosition) {
        if (bitPosition != 0) {
            throw new UnsupportedOperationException();
        }
    }

    @Nonnull
    public String toString() {
        return String.format("SixteenBitsReader[bufferSize=%d]", this.byteBuffer.length);
    }
}

